"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionResultsRoute = void 0;
var _rxjs = require("rxjs");
var _server = require("@kbn/data-plugin/server");
var _route_validation = require("../../utils/build_validation/route_validation");
var _get_action_results_route = require("../../../common/api/action_results/get_action_results_route");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _search_strategy = require("../../../common/search_strategy");
var _build_query = require("../../../common/utils/build_query");
var _get_internal_saved_object_client = require("../../utils/get_internal_saved_object_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionResultsRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'public',
    path: '/api/osquery/action_results/{actionId}',
    security: {
      authz: {
        requiredPrivileges: [`${_common.PLUGIN_ID}-read`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _route_validation.buildRouteValidation)(_get_action_results_route.getActionResultsRequestQuerySchema),
        params: (0, _route_validation.buildRouteValidation)(_get_action_results_route.getActionResultsRequestParamsSchema)
      }
    }
  }, async (context, request, response) => {
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    try {
      var _osqueryContext$servi, _request$query$page, _request$query$pageSi, _request$query$totalA, _request$query$sortOr, _request$query$sort, _integrationNamespace, _res$rawResponse, _res$rawResponse$aggr, _responseAgg$doc_coun, _responseAgg$rows_cou, _responseAgg$rows_cou2, _aggsBuckets$find$doc, _aggsBuckets$find, _aggsBuckets$find$doc2, _aggsBuckets$find2;
      let integrationNamespaces = {};
      const logger = osqueryContext.logFactory.get('get_action_results');
      if (osqueryContext !== null && osqueryContext !== void 0 && (_osqueryContext$servi = osqueryContext.service) !== null && _osqueryContext$servi !== void 0 && _osqueryContext$servi.getIntegrationNamespaces) {
        const spaceScopedClient = await (0, _get_internal_saved_object_client.createInternalSavedObjectsClientForSpaceId)(osqueryContext, request);
        integrationNamespaces = await osqueryContext.service.getIntegrationNamespaces([_common.OSQUERY_INTEGRATION_NAME], spaceScopedClient, logger);
        logger.debug(`Retrieved integration namespaces: ${JSON.stringify(integrationNamespaces)}`);
      }
      const search = await context.search;

      // Parse agentIds from query parameter
      const agentIds = request.query.agentIds ? request.query.agentIds.split(',').map(id => id.trim()) : [];
      const page = (_request$query$page = request.query.page) !== null && _request$query$page !== void 0 ? _request$query$page : 0;
      const pageSize = (_request$query$pageSi = request.query.pageSize) !== null && _request$query$pageSi !== void 0 ? _request$query$pageSi : 100;
      const totalAgentCount = (_request$query$totalA = request.query.totalAgents) !== null && _request$query$totalA !== void 0 ? _request$query$totalA : agentIds.length;
      const res = await (0, _rxjs.lastValueFrom)(search.search({
        actionId: request.params.actionId,
        factoryQueryType: _search_strategy.OsqueryQueries.actionResults,
        agentIds,
        kuery: request.query.kuery,
        startDate: request.query.startDate,
        // Client already sliced agents for current page, so fetch all of them (no pagination)
        pagination: agentIds.length > 0 ? (0, _build_query.generateTablePaginationOptions)(0, agentIds.length) : (0, _build_query.generateTablePaginationOptions)(page, pageSize),
        sort: {
          direction: (_request$query$sortOr = request.query.sortOrder) !== null && _request$query$sortOr !== void 0 ? _request$query$sortOr : _search_strategy.Direction.desc,
          field: (_request$query$sort = request.query.sort) !== null && _request$query$sort !== void 0 ? _request$query$sort : '@timestamp'
        },
        integrationNamespaces: (_integrationNamespace = integrationNamespaces[_common.OSQUERY_INTEGRATION_NAME]) !== null && _integrationNamespace !== void 0 && _integrationNamespace.length ? integrationNamespaces[_common.OSQUERY_INTEGRATION_NAME] : undefined
      }, {
        abortSignal,
        strategy: 'osquerySearchStrategy'
      }));
      const responseAgg = (_res$rawResponse = res.rawResponse) === null || _res$rawResponse === void 0 ? void 0 : (_res$rawResponse$aggr = _res$rawResponse.aggregations) === null || _res$rawResponse$aggr === void 0 ? void 0 : _res$rawResponse$aggr.aggs.responses_by_action_id;
      const totalResponded = (_responseAgg$doc_coun = responseAgg === null || responseAgg === void 0 ? void 0 : responseAgg.doc_count) !== null && _responseAgg$doc_coun !== void 0 ? _responseAgg$doc_coun : 0;
      const totalRowCount = (_responseAgg$rows_cou = responseAgg === null || responseAgg === void 0 ? void 0 : (_responseAgg$rows_cou2 = responseAgg.rows_count) === null || _responseAgg$rows_cou2 === void 0 ? void 0 : _responseAgg$rows_cou2.value) !== null && _responseAgg$rows_cou !== void 0 ? _responseAgg$rows_cou : 0;
      const aggsBuckets = responseAgg === null || responseAgg === void 0 ? void 0 : responseAgg.responses.buckets;
      const aggregations = {
        totalRowCount,
        totalResponded,
        successful: (_aggsBuckets$find$doc = aggsBuckets === null || aggsBuckets === void 0 ? void 0 : (_aggsBuckets$find = aggsBuckets.find(bucket => bucket.key === 'success')) === null || _aggsBuckets$find === void 0 ? void 0 : _aggsBuckets$find.doc_count) !== null && _aggsBuckets$find$doc !== void 0 ? _aggsBuckets$find$doc : 0,
        failed: (_aggsBuckets$find$doc2 = aggsBuckets === null || aggsBuckets === void 0 ? void 0 : (_aggsBuckets$find2 = aggsBuckets.find(bucket => bucket.key === 'error')) === null || _aggsBuckets$find2 === void 0 ? void 0 : _aggsBuckets$find2.doc_count) !== null && _aggsBuckets$find$doc2 !== void 0 ? _aggsBuckets$find$doc2 : 0,
        pending: Math.max(0, totalAgentCount - totalResponded)
      };

      // Return only real responses - placeholders will be generated client-side
      const processedEdges = res.edges;
      const totalPages = Math.ceil(totalAgentCount / pageSize);
      return response.ok({
        body: {
          edges: processedEdges,
          total: totalAgentCount,
          currentPage: page,
          pageSize,
          totalPages,
          aggregations,
          inspect: res.inspect
        }
      });
    } catch (err) {
      const error = err;
      return response.customError({
        statusCode: 500,
        body: {
          message: error.message
        }
      });
    }
  });
};
exports.getActionResultsRoute = getActionResultsRoute;