"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueriesField = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _immer = require("immer");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../../../common/constants");
var _pack_queries_table = require("../pack_queries_table");
var _query_flyout = require("../queries/query_flyout");
var _pack_uploader = require("./pack_uploader");
var _helpers = require("../queries/platforms/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/queries_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueriesFieldComponent = ({
  euiFieldProps
}) => {
  const {
    field: {
      value: fieldValue
    }
  } = (0, _reactHookForm.useController)({
    name: 'queries',
    defaultValue: [],
    rules: {}
  });
  const {
    append,
    remove,
    update,
    replace
  } = (0, _reactHookForm.useFieldArray)({
    name: 'queries'
  });
  const {
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    name: packName
  } = (0, _reactHookForm.useWatch)();
  const handleNameChange = (0, _react.useCallback)(newName => (0, _lodash.isEmpty)(packName) && setValue('name', newName), [packName, setValue]);
  const isReadOnly = !!(euiFieldProps !== null && euiFieldProps !== void 0 && euiFieldProps.isDisabled);
  const [showAddQueryFlyout, setShowAddQueryFlyout] = (0, _react.useState)(false);
  const [showEditQueryFlyout, setShowEditQueryFlyout] = (0, _react.useState)(-1);
  const [tableSelectedItems, setTableSelectedItems] = (0, _react.useState)([]);
  const handleShowAddFlyout = (0, _react.useCallback)(() => setShowAddQueryFlyout(true), []);
  const handleHideAddFlyout = (0, _react.useCallback)(() => setShowAddQueryFlyout(false), []);
  const handleHideEditFlyout = (0, _react.useCallback)(() => setShowEditQueryFlyout(-1), []);
  const handleDeleteClick = (0, _react.useCallback)(query => {
    const streamIndex = (0, _lodash.findIndex)(fieldValue, ['id', query.id]);
    if (streamIndex > -1) {
      remove(streamIndex);
    }
  }, [fieldValue, remove]);
  const handleEditClick = (0, _react.useCallback)(query => {
    const streamIndex = (0, _lodash.findIndex)(fieldValue, ['id', query.id]);
    setShowEditQueryFlyout(streamIndex);
  }, [fieldValue]);
  const handleEditQuery = (0, _react.useCallback)(updatedQuery => new Promise(resolve => {
    if (showEditQueryFlyout >= 0) {
      update(showEditQueryFlyout, (0, _immer.produce)({}, draft => {
        var _updatedQuery$platfor, _updatedQuery$version;
        draft.id = updatedQuery.id;
        draft.interval = updatedQuery.interval;
        draft.query = updatedQuery.query;
        draft.timeout = updatedQuery.timeout;
        if ((_updatedQuery$platfor = updatedQuery.platform) !== null && _updatedQuery$platfor !== void 0 && _updatedQuery$platfor.length) {
          draft.platform = updatedQuery.platform;
        }
        if ((_updatedQuery$version = updatedQuery.version) !== null && _updatedQuery$version !== void 0 && _updatedQuery$version.length) {
          draft.version = updatedQuery.version;
        }
        if (updatedQuery.ecs_mapping) {
          draft.ecs_mapping = updatedQuery.ecs_mapping;
        }
        draft.snapshot = updatedQuery.snapshot;
        draft.removed = updatedQuery.removed;
        return draft;
      }));
    }
    handleHideEditFlyout();
    resolve();
  }), [handleHideEditFlyout, update, showEditQueryFlyout]);
  const handleAddQuery = (0, _react.useCallback)(newQuery => new Promise(resolve => {
    append(newQuery);
    handleHideAddFlyout();
    resolve();
  }), [handleHideAddFlyout, append]);
  const handleDeleteQueries = (0, _react.useCallback)(() => {
    const idsToRemove = (0, _lodash.map)(tableSelectedItems, selectedItem => (0, _lodash.indexOf)(fieldValue, selectedItem));
    remove(idsToRemove);
    setTableSelectedItems([]);
  }, [fieldValue, remove, tableSelectedItems]);
  const handlePackUpload = (0, _react.useCallback)((parsedContent, uploadedPackName) => {
    replace((0, _lodash.map)(parsedContent.queries, (newQuery, newQueryId) => {
      var _ref, _newQuery$interval, _ref2, _newQuery$timeout, _newQuery$version, _newQuery$snapshot, _newQuery$removed, _newQuery$platform;
      return (0, _lodash.pickBy)({
        id: newQueryId,
        interval: (_ref = (_newQuery$interval = newQuery.interval) !== null && _newQuery$interval !== void 0 ? _newQuery$interval : parsedContent.interval) !== null && _ref !== void 0 ? _ref : '3600',
        timeout: (_ref2 = (_newQuery$timeout = newQuery.timeout) !== null && _newQuery$timeout !== void 0 ? _newQuery$timeout : parsedContent.timeout) !== null && _ref2 !== void 0 ? _ref2 : _constants.QUERY_TIMEOUT.DEFAULT,
        query: newQuery.query,
        version: (_newQuery$version = newQuery.version) !== null && _newQuery$version !== void 0 ? _newQuery$version : parsedContent.version,
        snapshot: (_newQuery$snapshot = newQuery.snapshot) !== null && _newQuery$snapshot !== void 0 ? _newQuery$snapshot : parsedContent.snapshot,
        removed: (_newQuery$removed = newQuery.removed) !== null && _newQuery$removed !== void 0 ? _newQuery$removed : parsedContent.removed,
        platform: (0, _helpers.getSupportedPlatforms)((_newQuery$platform = newQuery.platform) !== null && _newQuery$platform !== void 0 ? _newQuery$platform : parsedContent.platform)
      }, value => !(0, _lodash.isEmpty)(value) || value === false);
    }));
    handleNameChange(uploadedPackName);
  }, [handleNameChange, replace]);
  const tableData = (0, _react.useMemo)(() => fieldValue !== null && fieldValue !== void 0 && fieldValue.length ? fieldValue : [], [fieldValue]);
  const uniqueQueryIds = (0, _react.useMemo)(() => (0, _lodash.uniq)((0, _lodash.map)(fieldValue, 'id')), [fieldValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isReadOnly && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, !tableSelectedItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-query-button",
    fill: true,
    onClick: handleShowAddFlyout,
    iconType: "plusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queriesForm.addQueryButtonLabel",
    defaultMessage: "Add query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleDeleteQueries,
    iconType: "trash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.table.deleteQueriesButtonLabel",
    defaultMessage: "Delete {queriesCount, plural, one {# query} other {# queries}}"
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    values: {
      queriesCount: tableSelectedItems.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), fieldValue !== null && fieldValue !== void 0 && fieldValue.length ? /*#__PURE__*/_react.default.createElement(_pack_queries_table.PackQueriesTable, {
    data: tableData,
    isReadOnly: isReadOnly,
    onEditClick: handleEditClick,
    onDeleteClick: handleDeleteClick,
    selectedItems: tableSelectedItems,
    setSelectedItems: setTableSelectedItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), !isReadOnly && /*#__PURE__*/_react.default.createElement(_pack_uploader.OsqueryPackUploader, {
    onChange: handlePackUpload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 23
    }
  }), showAddQueryFlyout && /*#__PURE__*/_react.default.createElement(_query_flyout.QueryFlyout, {
    uniqueQueryIds: uniqueQueryIds,
    onSave: handleAddQuery,
    onClose: handleHideAddFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), showEditQueryFlyout != null && showEditQueryFlyout >= 0 && /*#__PURE__*/_react.default.createElement(_query_flyout.QueryFlyout, {
    uniqueQueryIds: uniqueQueryIds
    // @ts-expect-error update types
    ,
    defaultValue: fieldValue[showEditQueryFlyout],
    onSave: handleEditQuery,
    onClose: handleHideEditFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }));
};
const QueriesField = exports.QueriesField = /*#__PURE__*/_react.default.memo(QueriesFieldComponent, _fastDeepEqual.default);