"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osqueryTablesRecord = exports.normalizeTables = exports.getOsqueryTables = exports.getOsqueryTableNames = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeTables = tablesJSON => (0, _lodash.sortBy)(tablesJSON, 'name');
exports.normalizeTables = normalizeTables;
let osqueryTables = null;
const getOsqueryTables = () => {
  if (!osqueryTables) {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    osqueryTables = normalizeTables(require('../common/schemas/osquery/v5.19.0.json'));
  }
  return osqueryTables;
};
exports.getOsqueryTables = getOsqueryTables;
const normalizedOsqueryTables = getOsqueryTables();
const osqueryTablesRecord = exports.osqueryTablesRecord = normalizedOsqueryTables.reduce((acc, table) => ({
  ...acc,
  [table.name]: table
}), {});
const getOsqueryTableNames = () => (0, _lodash.flatMap)(normalizedOsqueryTables, 'name');
exports.getOsqueryTableNames = getOsqueryTableNames;