"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockedInternalAgent = exports.createMockedAgentRegistry = exports.createMockedAgent = exports.createAgentsServiceStartMock = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMockedAgentRegistry = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    create: jest.fn(),
    update: jest.fn(),
    list: jest.fn(),
    delete: jest.fn()
  };
};
exports.createMockedAgentRegistry = createMockedAgentRegistry;
const createMockedAgent = (parts = {}) => {
  return {
    type: _onechatCommon.AgentType.chat,
    id: 'test_agent',
    name: 'Test Agent',
    description: 'My test agent',
    configuration: {
      tools: []
    },
    readonly: false,
    ...parts
  };
};
exports.createMockedAgent = createMockedAgent;
const createMockedInternalAgent = (parts = {}) => {
  return {
    type: _onechatCommon.AgentType.chat,
    id: 'test_agent',
    name: 'Test Agent',
    description: 'My test agent',
    configuration: {
      tools: []
    },
    readonly: false,
    isAvailable: jest.fn(),
    ...parts
  };
};
exports.createMockedInternalAgent = createMockedInternalAgent;
const createAgentsServiceStartMock = () => {
  return {
    execute: jest.fn(),
    getRegistry: jest.fn().mockImplementation(() => createMockedAgentRegistry())
  };
};
exports.createAgentsServiceStartMock = createAgentsServiceStartMock;