"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentExecutionErrorCode = getAgentExecutionErrorCode;
exports.normalizeErrorType = normalizeErrorType;
exports.sanitizeForCounterName = sanitizeForCounterName;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Normalize error type/code from error object
 * @param error - Error object
 */
function normalizeErrorType(error) {
  if ((0, _onechatCommon.isOnechatError)(error)) {
    return error.code || _onechatCommon.OnechatErrorCode.internalError;
  }
  return 'other';
}

/**
 * Extract the AgentExecutionErrorCode sub-type from an agentExecutionError.
 * Returns undefined if the error is not an agentExecutionError or doesn't have a sub-code.
 * @param error - Error object
 */
function getAgentExecutionErrorCode(error) {
  if ((0, _onechatCommon.isAgentExecutionError)(error)) {
    var _error$meta;
    return (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.errCode;
  }
  return undefined;
}

/**
 * Sanitize text for use in counter names
 * Counter names must be valid identifiers and cannot contain special characters
 * @param text - Text to sanitize
 * @returns Sanitized text safe for counter names
 */
function sanitizeForCounterName(text) {
  let sanitized = text.replace(/[^a-zA-Z0-9_-]/g, '_');
  sanitized = sanitized.replace(/_+/g, '_');
  sanitized = sanitized.replace(/^_+|_+$/g, '');
  const maxLength = 100;
  if (sanitized.length > maxLength) {
    sanitized = sanitized.substring(0, maxLength);
  }
  if (!sanitized) {
    sanitized = 'unknown';
  }
  return sanitized.toLowerCase();
}