"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolTypeDefinitions = void 0;
var _esql = require("./esql");
var _index_search = require("./index_search");
var _workflow = require("./workflow");
var _builtin = require("./builtin");
var _mcp = require("./mcp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getToolTypeDefinitions = ({
  workflowsManagement,
  actions
}) => {
  const toolTypes = [(0, _builtin.getBuiltinToolType)(), (0, _esql.getEsqlToolType)(), (0, _index_search.getIndexSearchToolType)(), (0, _workflow.getWorkflowToolType)({
    workflowsManagement
  }), (0, _mcp.getMcpToolType)({
    actions
  })];
  return toolTypes;
};
exports.getToolTypeDefinitions = getToolTypeDefinitions;