"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlToolType = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _create_handler = require("./create_handler");
var _create_schema = require("./create_schema");
var _validate_configuration = require("./validate_configuration");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEsqlToolType = () => {
  return {
    toolType: _onechatCommon.ToolType.esql,
    getDynamicProps: config => {
      return {
        getHandler: () => (0, _create_handler.createHandler)(config),
        getSchema: () => (0, _create_schema.createSchemaFromParams)(config.params)
      };
    },
    createSchema: _schemas.configurationSchema,
    updateSchema: _schemas.configurationUpdateSchema,
    validateForCreate: async ({
      config
    }) => {
      await (0, _validate_configuration.validateConfig)(config);
      return config;
    },
    validateForUpdate: async ({
      update,
      current
    }) => {
      const mergedConfig = {
        ...current,
        ...update
      };
      await (0, _validate_configuration.validateConfig)(mergedConfig);
      return mergedConfig;
    }
  };
};
exports.getEsqlToolType = getEsqlToolType;