"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractConversationToolResults = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractConversationToolResults = conversation => {
  const results = [];
  for (const round of conversation) {
    const toolCalls = round.steps.filter(_onechatCommon.isToolCallStep).flatMap(toolCall => toolCall.results);
    results.push(...toolCalls);
  }
  return results;
};
exports.extractConversationToolResults = extractConversationToolResults;