"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _allow_lists = require("@kbn/onechat-server/allow_lists");
var _spaces = require("../../utils/spaces");
var _builtin = require("./builtin");
var _persisted = require("./persisted");
var _agent_registry = require("./agent_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentsService {
  constructor() {
    (0, _defineProperty2.default)(this, "builtinRegistry", void 0);
    (0, _defineProperty2.default)(this, "setupDeps", void 0);
    this.builtinRegistry = (0, _builtin.createBuiltinAgentRegistry)();
  }
  setup(setupDeps) {
    this.setupDeps = setupDeps;
    (0, _builtin.registerBuiltinAgents)({
      registry: this.builtinRegistry
    });
    return {
      register: agent => {
        if (!(0, _allow_lists.isAllowedBuiltinAgent)(agent.id)) {
          throw new Error(`Built-in agent with id "${agent.id}" is not in the list of allowed built-in agents.
             Please add it to the list of allowed built-in agents in the "@kbn/onechat-server/allow_lists.ts" file.`);
        }
        this.builtinRegistry.register(agent);
      }
    };
  }
  start(startDeps) {
    if (!this.setupDeps) {
      throw new Error('#start called before #setup');
    }
    const {
      logger
    } = this.setupDeps;
    const {
      getRunner,
      security,
      elasticsearch,
      spaces,
      toolsService,
      uiSettings,
      savedObjects
    } = startDeps;
    const builtinProviderFn = (0, _builtin.createBuiltinProviderFn)({
      registry: this.builtinRegistry
    });
    const persistedProviderFn = (0, _persisted.createPersistedProviderFn)({
      elasticsearch,
      security,
      toolsService,
      logger
    });
    const getRegistry = async ({
      request
    }) => {
      const space = (0, _spaces.getCurrentSpaceId)({
        request,
        spaces
      });
      return (0, _agent_registry.createAgentRegistry)({
        request,
        spaceId: space,
        uiSettings,
        savedObjects,
        builtinProvider: await builtinProviderFn({
          request,
          space
        }),
        persistedProvider: await persistedProviderFn({
          request,
          space
        })
      });
    };
    return {
      getRegistry,
      execute: async args => {
        return getRunner().runAgent(args);
      }
    };
  }
}
exports.AgentsService = AgentsService;