"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgentStepDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _step_types = require("../../common/step_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runAgentStepDefinition = exports.runAgentStepDefinition = {
  ..._step_types.runAgentStepCommonDefinition,
  label: _i18n.i18n.translate('xpack.onechat.runAgentStep.label', {
    defaultMessage: 'Run Agent'
  }),
  description: _i18n.i18n.translate('xpack.onechat.runAgentStep.description', {
    defaultMessage: 'Execute an Onechat AI agent to process input and generate responses'
  }),
  documentation: {
    details: _i18n.i18n.translate('xpack.onechat.runAgentStep.documentation.details', {
      defaultMessage: 'The onechat.runAgent step allows you to invoke an AI agent within your workflow. The agent will process the input message and return a response, optionally using tools and maintaining conversation context.'
    }),
    examples: [`## Basic agent invocation
\`\`\`yaml
- name: run_agent
  type: ${_step_types.RunAgentStepTypeId}
  with:
    message: "Analyze the following data and provide insights"
\`\`\``, `## Use a specific agent
\`\`\`yaml
- name: custom_agent
  type: ${_step_types.RunAgentStepTypeId}
  with:
    agent_id: "my-custom-agent"
    message: "{{ workflow.input.message }}"
\`\`\``]
  }
};