"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConversationInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _embeddable_conversations_provider = require("../application/context/conversation/embeddable_conversations_provider");
var _conversation = require("../application/components/conversations/conversation");
var _conversation_header = require("../application/components/conversations/conversation_header/conversation_header");
var _conversation2 = require("../application/components/conversations/conversation.styles");
var _embeddable_welcome_message = require("./embeddable_welcome_message");
var _embeddable_access_boundary = require("./embeddable_access_boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/embeddable_conversation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmbeddableConversationInternal = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onClose,
    ariaLabelledBy
  } = props;
  const wrapperStyles = (0, _react2.css)`
    display: flex;
    flex-direction: column;
    height: 100%;
    ${(0, _conversation2.conversationBackgroundStyles)(euiTheme)}
  `;
  const headerStyles = (0, _react2.css)`
    display: flex;
    height: ${_conversation2.headerHeight}px;
    &.euiFlyoutHeader {
      padding-inline: 0;
      padding-block-start: 0;
      padding: ${euiTheme.size.base};
    }
  `;
  const bodyStyles = (0, _react2.css)`
    flex: 1;
    min-height: 0;

    .euiFlyoutBody__overflow {
      overflow: hidden;
      height: 100%;
    }

    .euiFlyoutBody__overflowContent {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      height: 100%;
      overflow: hidden;
      padding: 0;
    }
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: wrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_embeddable_conversations_provider.EmbeddableConversationsProvider, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_embeddable_access_boundary.EmbeddableAccessBoundary, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    css: headerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_header.ConversationHeader, {
    onClose: onClose,
    ariaLabelledBy: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_embeddable_welcome_message.EmbeddableWelcomeMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: bodyStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation.Conversation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  })))));
};
exports.EmbeddableConversationInternal = EmbeddableConversationInternal;