"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roundedBorderRadiusStyles = exports.pushFlyoutPaddingStyles = exports.lineClampStyles = exports.borderRadiusXlStyles = exports.ROUNDED_BORDER_RADIUS_LARGE = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Can be used for any portal content that would be covered by the push flyout
const pushFlyoutPaddingStyles = exports.pushFlyoutPaddingStyles = (0, _react.css)`
  ${(0, _eui.logicalCSS)('padding-right', `var(--euiPushFlyoutOffsetInlineEnd, 0px)`)};
  ${(0, _eui.logicalCSS)('padding-left', `var(--euiPushFlyoutOffsetInlineStart, 0px)`)};
`;
const ROUNDED_BORDER_RADIUS = '6px';
const ROUNDED_BORDER_RADIUS_LARGE = exports.ROUNDED_BORDER_RADIUS_LARGE = '12px';
const ROUNDED_BORDER_RADIUS_EXTRA_LARGE = '16px';
const roundedBorderRadiusStyles = exports.roundedBorderRadiusStyles = (0, _react.css)`
  border-radius: ${ROUNDED_BORDER_RADIUS};
`;
const borderRadiusXlStyles = exports.borderRadiusXlStyles = (0, _react.css)`
  border-radius: ${ROUNDED_BORDER_RADIUS_EXTRA_LARGE};
`;
const lineClampStyles = numLines => (0, _react.css)`
  display: -webkit-box;
  -webkit-line-clamp: ${numLines};
  -webkit-box-orient: vertical;
  overflow: hidden;
`;
exports.lineClampStyles = lineClampStyles;