"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidateNamespace = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../../query_keys");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useValidateNamespace = ({
  namespace,
  enabled
}) => {
  var _data$isValid, _data$conflictingName;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const isEnabled = enabled !== null && enabled !== void 0 ? enabled : namespace.length > 0;
  const {
    data,
    isLoading,
    error,
    isError,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.namespace.validate(namespace),
    queryFn: () => toolsService.validateNamespace({
      namespace
    }),
    enabled: isEnabled,
    staleTime: 0
  });
  return {
    isValid: (_data$isValid = data === null || data === void 0 ? void 0 : data.isValid) !== null && _data$isValid !== void 0 ? _data$isValid : true,
    conflictingNamespaces: (_data$conflictingName = data === null || data === void 0 ? void 0 : data.conflictingNamespaces) !== null && _data$conflictingName !== void 0 ? _data$conflictingName : [],
    isLoading: isLoading && isEnabled,
    isFetching,
    error,
    isError
  };
};
exports.useValidateNamespace = useValidateNamespace;