"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationContext = exports.ConversationContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConversationContext = exports.ConversationContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useConversationContext = () => {
  const context = (0, _react.useContext)(ConversationContext);
  if (context === undefined) {
    throw new Error('useConversationContext must be used within a ConversationContext.Provider');
  }
  return context;
};
exports.useConversationContext = useConversationContext;