"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpConnectionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _public = require("@kbn/kibana-react-plugin/public");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _doc_links = require("../../../../../common/doc_links");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
var _mcp = require("../../../../../common/mcp");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/mcp_server/mcp_connection_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const McpConnectionButton = () => {
  const mcpEnabled = (0, _public.useUiSetting)(_managementSettingsIds.AGENT_BUILDER_EXTERNAL_MCP_SETTING_ID, false);
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    kibanaUrl
  } = (0, _use_kibana_url.useKibanaUrl)();
  const [isContextOpen, toggleContextOpen] = (0, _useToggle.default)(false);
  const mcpServerUrl = `${kibanaUrl}${_mcp.MCP_SERVER_PATH}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      key: "mcp-server-connection-button",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: toggleContextOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.mcpServerConnectionButton', {
      defaultMessage: 'Manage MCP'
    }))),
    isOpen: isContextOpen,
    closePopover: () => toggleContextOpen(false),
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      key: "copy",
      textToCopy: mcpServerUrl,
      tooltipProps: {
        anchorClassName: 'eui-fullWidth'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "copy",
      icon: "copy",
      onClick: copy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.copyMcpServerUrlButton', {
      defaultMessage: 'Copy MCP Server URL'
    }))), ...(mcpEnabled ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "bulkImportMcpTools",
      icon: "plus",
      href: createOnechatUrl(_app_paths.appPaths.tools.bulkImportMcp),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcpToolsButton', {
      defaultMessage: 'Bulk import MCP tools'
    }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "documentation",
      icon: "documentation",
      href: _doc_links.docLinks.mcpServer,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.aboutMcpServerDocumentationButton', {
      defaultMessage: 'Documentation'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
exports.McpConnectionButton = McpConnectionButton;