"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mcpToolFormValidationSchema = void 0;
var _i18n = require("@kbn/i18n");
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _shared_tool_validation = require("./shared_tool_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mcpI18nMessages = {
  connector: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.mcp.connector_id.requiredError', {
      defaultMessage: 'MCP Server is required.'
    })
  },
  mcpTool: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.mcp.mcp_tool_name.requiredError', {
      defaultMessage: 'Tool is required.'
    })
  }
};
const mcpToolFormValidationSchema = exports.mcpToolFormValidationSchema = _zod.z.object({
  ..._shared_tool_validation.sharedValidationSchemas,
  connectorId: _zod.z.string().min(1, {
    message: mcpI18nMessages.connector.requiredError
  }),
  mcpToolName: _zod.z.string().min(1, {
    message: mcpI18nMessages.mcpTool.requiredError
  }),
  type: _zod.z.literal(_onechatCommon.ToolType.mcp)
});