"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpConfiguration = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _mcp = require("../../types/mcp");
var _i18n = require("../../i18n");
var _tool_form = require("../../tool_form");
var _mcp_editable_fields = require("../../components/mcp/mcp_editable_fields");
var _mcp_readonly_fields = require("../../components/mcp/mcp_readonly_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/configuration_fields/mcp_configuration_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const McpConfiguration = ({
  mode
}) => {
  const [mcpHealthStatus, setMcpHealthStatus] = (0, _react2.useState)();
  const isCreatingTool = mode === _tool_form.ToolFormMode.Create;
  const ConfigurationFields = isCreatingTool ? _mcp_editable_fields.McpEditableFields : _mcp_readonly_fields.McpReadOnlyFields;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, {
    css: ({
      euiTheme
    }) => (0, _react.css)`
            padding-bottom: ${euiTheme.size.s};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  }, _i18n.i18nMessages.configuration.form.mcp.mcpToolDetailsTitle)), !isCreatingTool && (mcpHealthStatus ? /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
    color: mcpHealthStatus === _mcp.McpToolHealthStatus.Healthy ? 'success' : 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 17
    }
  }, mcpHealthStatus === _mcp.McpToolHealthStatus.Healthy ? _i18n.i18nMessages.configuration.form.mcp.mcpHealthStatusHealthy : _i18n.i18nMessages.configuration.form.mcp.mcpHealthStatusError) : /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 19
    }
  }, _i18n.i18nMessages.configuration.form.mcp.mcpHealthStatusLoading))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(ConfigurationFields, {
    mcpHealthStatus: mcpHealthStatus,
    setMcpHealthStatus: setMcpHealthStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))));
};
exports.McpConfiguration = McpConfiguration;