"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSearchConfiguration = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _index_search_pattern = require("../../components/index_search/index_search_pattern");
var _i18n = require("../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/configuration_fields/index_search_configuration_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexSearchConfiguration = () => {
  var _errors$pattern, _errors$rowLimit, _errors$customInstruc;
  const {
    control,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.indexSearch.patternLabel,
    isInvalid: !!errors.pattern,
    error: (_errors$pattern = errors.pattern) === null || _errors$pattern === void 0 ? void 0 : _errors$pattern.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_index_search_pattern.IndexSearchPattern, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.indexSearch.defaultRowLimitLabel,
    helpText: _i18n.i18nMessages.configuration.form.indexSearch.defaultRowLimitHelpText,
    isInvalid: !!errors.rowLimit,
    error: (_errors$rowLimit = errors.rowLimit) === null || _errors$rowLimit === void 0 ? void 0 : _errors$rowLimit.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "rowLimit",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      onChange: e => field.onChange(isNaN(e.target.valueAsNumber) ? undefined : e.target.valueAsNumber),
      min: 1,
      step: 1,
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.indexSearch.customInstructionsLabel,
    helpText: _i18n.i18nMessages.configuration.form.indexSearch.customInstructionsHelpText,
    isInvalid: !!errors.customInstructions,
    error: (_errors$customInstruc = errors.customInstructions) === null || _errors$customInstruc === void 0 ? void 0 : _errors$customInstruc.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "customInstructions",
    control: control,
    render: ({
      field
    }) => {
      var _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({}, field, {
        value: (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '',
        placeholder: _i18n.i18nMessages.configuration.form.indexSearch.customInstructionsPlaceholder,
        rows: 3,
        compressed: true,
        fullWidth: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
};
exports.IndexSearchConfiguration = IndexSearchConfiguration;