"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditMcpServerFlyout = void 0;
var _react = require("react");
var _tools = require("../../../../../../common/http_api/tools");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_flyout_state = require("../../../../hooks/use_flyout_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditMcpServerFlyout = ({
  connector
}) => {
  const {
    services: {
      plugins: {
        triggersActionsUi
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    openFlyout,
    closeFlyout,
    isOpen
  } = (0, _use_flyout_state.useFlyoutState)();
  const flyout = (0, _react.useMemo)(() => {
    var _connector$config;
    return connector && (0, _tools.isMcpConnectorItem)(connector) ? triggersActionsUi.getEditConnectorFlyout({
      onClose: closeFlyout,
      connector: {
        ...connector,
        secrets: {},
        config: (_connector$config = connector.config) !== null && _connector$config !== void 0 ? _connector$config : {}
      }
    }) : null;
  }, [closeFlyout, connector, triggersActionsUi]);
  return {
    openFlyout,
    closeFlyout,
    isOpen,
    flyout
  };
};
exports.useEditMcpServerFlyout = useEditMcpServerFlyout;