"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThinkingItemLayout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _codeblock = require("./codeblock.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/thinking_item_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  parameters: _i18n.i18n.translate('xpack.onechat.round.thinking.steps.thinkingItemLayout.parameters', {
    defaultMessage: 'Parameters'
  }),
  close: _i18n.i18n.translate('xpack.onechat.round.thinking.steps.thinkingItemLayout.close', {
    defaultMessage: 'Close'
  }),
  open: _i18n.i18n.translate('xpack.onechat.round.thinking.steps.thinkingItemLayout.open', {
    defaultMessage: 'Open'
  })
};
const Accordion = ({
  children,
  accordionContent,
  textColor
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordionId'
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    css: (0, _react.css)`
        color: ${textColor};
      `,
    id: accordionId,
    arrowDisplay: "right",
    buttonContent: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "plain",
    grow: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }, labels.parameters))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    paddingSize: "m",
    lineNumbers: true,
    css: _codeblock.codeblockStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, JSON.stringify(accordionContent, null, 2))))));
};
const ThinkingItemLayout = ({
  children,
  icon,
  accordionContent,
  textColor
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: accordionContent ? undefined : 'center',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, icon && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            padding-top: ${accordionContent ? euiTheme.size.xs : '0px'};
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, icon), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, accordionContent ? /*#__PURE__*/_react2.default.createElement(Accordion, {
    textColor: textColor,
    accordionContent: accordionContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, children) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
              color: ${textColor};
            `,
    direction: "column",
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, children))));
};
exports.ThinkingItemLayout = ThinkingItemLayout;