"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVisualizationRenderer = createVisualizationRenderer;
exports.visualizationTagParser = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _visualize_esql = require("../../../../tools/esql/visualize_esql");
var _visualize_lens = require("../../../../tools/esql/visualize_lens");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/markdown_plugins/visualization_plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const visualizationTagParser = exports.visualizationTagParser = (0, _utils.createTagParser)({
  tagName: _tool_result.visualizationElement.tagName,
  getAttributes: (value, extractAttr) => ({
    toolResultId: extractAttr(value, _tool_result.visualizationElement.attributes.toolResultId),
    chartType: extractAttr(value, _tool_result.visualizationElement.attributes.chartType)
  }),
  assignAttributes: (node, attributes) => {
    node.type = _tool_result.visualizationElement.tagName;
    node.toolResultId = attributes.toolResultId;
    node.chartType = attributes.chartType;
    delete node.value;
  },
  createNode: (attributes, position) => ({
    type: _tool_result.visualizationElement.tagName,
    toolResultId: attributes.toolResultId,
    chartType: attributes.chartType,
    position
  })
});
function createVisualizationRenderer({
  startDependencies,
  stepsFromCurrentRound,
  stepsFromPrevRounds
}) {
  return props => {
    const {
      toolResultId,
      chartType
    } = props;
    if (!toolResultId) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 9
        }
      }, "Visualization missing ", _tool_result.visualizationElement.attributes.toolResultId, ".");
    }
    const steps = [...stepsFromPrevRounds, ...stepsFromCurrentRound];
    const ToolResultAttribute = /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, _tool_result.visualizationElement.attributes.toolResultId, "=", toolResultId);

    // First, look for tabular data results (from execute_esql)
    let toolResult = (0, _utils.findToolResult)(steps, toolResultId, _tool_result.ToolResultType.tabularData);

    // If not found, look for visualization results (from create_visualization)
    if (!toolResult) {
      toolResult = (0, _utils.findToolResult)(steps, toolResultId, _tool_result.ToolResultType.visualization);
    }
    if (!toolResult) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 14
        }
      }, "Unable to find visualization for ", ToolResultAttribute, ".");
    }

    // Handle visualization result (pre-built Lens config)
    if (toolResult.type === 'visualization') {
      const {
        visualization
      } = toolResult.data;
      return /*#__PURE__*/_react.default.createElement(_visualize_lens.VisualizeLens, {
        lensConfig: visualization,
        dataViews: startDependencies.dataViews,
        lens: startDependencies.lens,
        uiActions: startDependencies.uiActions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 9
        }
      });
    }
    const {
      columns,
      query
    } = toolResult.data;
    if (!query) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 14
        }
      }, "Unable to find esql query for ", ToolResultAttribute, ".");
    }
    return /*#__PURE__*/_react.default.createElement(_visualize_esql.VisualizeESQL, {
      lens: startDependencies.lens,
      dataViews: startDependencies.dataViews,
      uiActions: startDependencies.uiActions,
      esqlQuery: query,
      esqlColumns: columns,
      preferredChartType: chartType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    });
  };
}