"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundError = void 0;
var _react = _interopRequireDefault(require("react"));
var _onechatCommon = require("@kbn/onechat-common");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _context_exceeded_round_error = require("./context_exceeded_round_error");
var _generic_round_error = require("./generic_round_error");
var _round_error_thinking_panel = require("./round_error_thinking_panel");
var _round_steps = require("../round_thinking/steps/round_steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_error/round_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  retryAriaLabel: _i18n.i18n.translate('xpack.onechat.round.error.retryLabel', {
    defaultMessage: 'Retry'
  }),
  tryAgain: _i18n.i18n.translate('xpack.onechat.round.error.tryAgain', {
    defaultMessage: 'Try again?'
  })
};
const RoundError = ({
  error,
  errorSteps,
  onRetry
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const errorContent = (0, _onechatCommon.isContextLengthExceededAgentError)(error) ? /*#__PURE__*/_react.default.createElement(_context_exceeded_round_error.ContextExceededRoundError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_generic_round_error.GenericRoundError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    responsive: false,
    "data-test-subj": "agentBuilderRoundError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_round_error_thinking_panel.RoundErrorThinkingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_round_steps.RoundSteps, {
    isLoading: false,
    steps: errorSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }), errorContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _react2.css)`
              color: ${euiTheme.colors.textPrimary};
            `,
    "data-test-subj": "agentBuilderRoundErrorRetryButton",
    iconType: "refresh",
    onClick: onRetry,
    "aria-label": labels.retryAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, labels.tryAgain))));
};
exports.RoundError = RoundError;