"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/input_actions/connector_selector/connector_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getProviderIcon = key => _inferenceEndpointUiCommon.SERVICE_PROVIDERS[key].icon;
const connectorIcons = [{
  match: ['gpt', 'openai'],
  icon: getProviderIcon(_inferenceEndpointUiCommon.ServiceProviderKeys.openai)
}, {
  match: ['claude', 'anthropic'],
  icon: getProviderIcon(_inferenceEndpointUiCommon.ServiceProviderKeys.anthropic)
}, {
  match: ['gemini'],
  icon: _common.GeminiLogo
}, {
  match: ['elastic'],
  icon: 'logoElastic'
}];
const fallbackIconType = 'compute';
const ConnectorIcon = ({
  connectorName
}) => {
  let iconType = fallbackIconType;
  if (connectorName) {
    const normalizedName = connectorName.toLowerCase();
    const matchedIcon = connectorIcons.find(config => config.match.some(matchString => normalizedName.includes(matchString)));
    if (matchedIcon) {
      iconType = matchedIcon.icon;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 10
    }
  });
};
exports.ConnectorIcon = ConnectorIcon;