"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MoreActionsButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_is_agent_read_only = require("../../../hooks/agents/use_is_agent_read_only");
var _use_navigation = require("../../../hooks/use_navigation");
var _use_conversation = require("../../../hooks/use_conversation");
var _use_kibana = require("../../../hooks/use_kibana");
var _search_param_names = require("../../../search_param_names");
var _app_paths = require("../../../utils/app_paths");
var _delete_conversation_modal = require("../delete_conversation_modal");
var _use_has_connectors_all_privileges = require("../../../hooks/use_has_connectors_all_privileges");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _robot = require("../../common/icons/robot");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/more_actions_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fullscreenLabels = {
  actions: _i18n.i18n.translate('xpack.onechat.conversationActions.actions', {
    defaultMessage: 'More'
  }),
  actionsAriaLabel: _i18n.i18n.translate('xpack.onechat.conversationActions.actionsAriaLabel', {
    defaultMessage: 'More'
  }),
  conversationTitleLabel: _i18n.i18n.translate('xpack.onechat.conversationActions.conversationTitleLabel', {
    defaultMessage: 'Conversation'
  }),
  editCurrentAgent: _i18n.i18n.translate('xpack.onechat.conversationActions.editCurrentAgent', {
    defaultMessage: 'Edit agent'
  }),
  cloneAgentAsNew: _i18n.i18n.translate('xpack.onechat.conversationActions.duplicateAgentAsNew', {
    defaultMessage: 'Duplicate as new'
  }),
  conversationAgentLabel: _i18n.i18n.translate('xpack.onechat.conversationActions.conversationAgentLabel', {
    defaultMessage: 'Agent'
  }),
  conversationManagementLabel: _i18n.i18n.translate('xpack.onechat.conversationActions.conversationManagementLabel', {
    defaultMessage: 'Management'
  }),
  agents: _i18n.i18n.translate('xpack.onechat.conversationActions.agents', {
    defaultMessage: 'View all agents'
  }),
  tools: _i18n.i18n.translate('xpack.onechat.conversationActions.tools', {
    defaultMessage: 'View all tools'
  }),
  rename: _i18n.i18n.translate('xpack.onechat.conversationActions.rename', {
    defaultMessage: 'Rename'
  }),
  delete: _i18n.i18n.translate('xpack.onechat.conversationActions.delete', {
    defaultMessage: 'Delete'
  }),
  genAiSettings: _i18n.i18n.translate('xpack.onechat.conversationActions.genAiSettings', {
    defaultMessage: 'Gen AI Settings'
  }),
  externalLinkAriaLabel: _i18n.i18n.translate('xpack.onechat.conversationActions.externalLinkAriaLabel', {
    defaultMessage: 'Open in new tab'
  })
};
const popoverMinWidthStyles = (0, _react2.css)`
  min-width: 240px;
`;
const MenuSectionTitle = ({
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    css: (0, _react2.css)`
          padding-left: ${euiTheme.size.s};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }));
};
const MoreActionsButton = ({
  onRenameConversation
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isDeleteModalOpen, setIsDeleteModalOpen] = (0, _react.useState)(false);
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const hasPersistedConversation = (0, _use_conversation.useHasPersistedConversation)();
  const agentId = (0, _use_conversation.useAgentId)();
  const isAgentReadOnly = (0, _use_is_agent_read_only.useIsAgentReadOnly)(agentId);
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    manageAgents
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const hasAccessToGenAiSettings = (0, _use_has_connectors_all_privileges.useHasConnectorsAllPrivileges)();
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const togglePopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const menuItems = [...(hasPersistedConversation ? [/*#__PURE__*/_react.default.createElement(MenuSectionTitle, {
    key: "conversation-title",
    title: fullscreenLabels.conversationTitleLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "rename",
    icon: "pencil",
    size: "s",
    "data-test-subj": "agentBuilderConversationRenameButton",
    onClick: () => {
      closePopover();
      onRenameConversation();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, fullscreenLabels.rename), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "delete",
    icon: "trash",
    size: "s",
    css: (0, _react2.css)`
              color: ${euiTheme.colors.textDanger};
            `,
    "data-test-subj": "agentBuilderConversationDeleteButton",
    onClick: () => {
      closePopover();
      setIsDeleteModalOpen(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, fullscreenLabels.delete)] : []), /*#__PURE__*/_react.default.createElement(MenuSectionTitle, {
    key: "agent-title",
    title: fullscreenLabels.conversationAgentLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "edit-current-agent",
    icon: "pencil",
    size: "s",
    disabled: isAgentReadOnly || !manageAgents,
    onClick: closePopover,
    href: agentId ? createOnechatUrl(_app_paths.appPaths.agents.edit({
      agentId
    })) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, fullscreenLabels.editCurrentAgent), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "clone-agent",
    icon: "copy",
    size: "s",
    disabled: !agentId || !manageAgents,
    onClick: closePopover,
    href: agentId ? createOnechatUrl(_app_paths.appPaths.agents.new, {
      [_search_param_names.searchParamNames.sourceId]: agentId
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }, fullscreenLabels.cloneAgentAsNew), /*#__PURE__*/_react.default.createElement(MenuSectionTitle, {
    key: "management-title",
    title: fullscreenLabels.conversationManagementLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "agents",
    icon: /*#__PURE__*/_react.default.createElement(_robot.RobotIcon, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }),
    onClick: closePopover,
    href: createOnechatUrl(_app_paths.appPaths.agents.list),
    "data-test-subj": "onechatActionsAgents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }, fullscreenLabels.agents), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "tools",
    icon: "wrench",
    onClick: closePopover,
    href: createOnechatUrl(_app_paths.appPaths.tools.list),
    "data-test-subj": "onechatActionsTools",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, fullscreenLabels.tools), ...(hasAccessToGenAiSettings ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "agentBuilderSettings",
    icon: "gear",
    onClick: closePopover,
    href: application.getUrlForApp('management', {
      path: '/ai/genAiSettings'
    }),
    "data-test-subj": "agentBuilderGenAiSettingsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, fullscreenLabels.genAiSettings)] : [])];
  const buttonProps = {
    iconType: 'boxesVertical',
    color: 'text',
    'aria-label': fullscreenLabels.actionsAriaLabel,
    onClick: togglePopover,
    'data-test-subj': 'agentBuilderMoreActionsButton'
  };
  const showButtonIcon = hasActiveConversation;
  const button = showButtonIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }), fullscreenLabels.actions);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "xs",
    anchorPosition: "downCenter",
    panelProps: {
      css: popoverMinWidthStyles
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_delete_conversation_modal.DeleteConversationModal, {
    isOpen: isDeleteModalOpen,
    onClose: () => setIsDeleteModalOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }));
};
exports.MoreActionsButton = MoreActionsButton;