"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationsHistoryButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_conversation = require("../../../hooks/use_conversation");
var _conversations_history_popover = require("../conversations_history/conversations_history_popover");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_list = require("../../../hooks/use_conversation_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/conversations_history_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  open: _i18n.i18n.translate('xpack.onechat.conversationsHistory.open', {
    defaultMessage: 'Open conversations'
  }),
  close: _i18n.i18n.translate('xpack.onechat.conversationsHistory.close', {
    defaultMessage: 'Close conversations'
  }),
  conversations: _i18n.i18n.translate('xpack.onechat.conversationsHistory.conversations', {
    defaultMessage: 'Conversations'
  })
};
const ConversationsHistoryButton = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isEmbeddedContext
  } = (0, _conversation_context.useConversationContext)();
  const {
    conversations,
    isLoading
  } = (0, _use_conversation_list.useConversationList)();
  const hasNoConversations = !isLoading && (conversations === null || conversations === void 0 ? void 0 : conversations.length) === 0;
  const togglePopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const paddingLeft = (0, _react2.css)`
    padding-left: ${euiTheme.size.s};
  `;
  const showButtonIcon = hasActiveConversation;
  const button = showButtonIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "clockCounter",
    color: "text",
    "aria-label": isPopoverOpen ? labels.close : labels.open,
    onClick: togglePopover,
    display: "empty",
    "data-test-subj": "onechatConversationsHistoryToggleBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "clockCounter",
    color: "text",
    "aria-label": isPopoverOpen ? labels.close : labels.open,
    onClick: togglePopover,
    "data-test-subj": "onechatConversationsHistoryToggleBtn",
    disabled: hasNoConversations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, labels.conversations);
  const shouldAddPaddingLeft = hasActiveConversation && !isEmbeddedContext;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    css: shouldAddPaddingLeft ? paddingLeft : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_conversations_history_popover.ConversationsHistoryPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.ConversationsHistoryButton = ConversationsHistoryButton;