"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_conversation = require("../../../hooks/use_conversation");
var _rename_conversation_input = require("./rename_conversation_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/conversation_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  ariaLabel: _i18n.i18n.translate('xpack.onechat.conversationTitle.ariaLabel', {
    defaultMessage: 'Conversation title'
  }),
  rename: _i18n.i18n.translate('xpack.onechat.conversationTitle.rename', {
    defaultMessage: 'Rename conversation'
  }),
  newConversation: _i18n.i18n.translate('xpack.onechat.conversationTitle.newConversation', {
    defaultMessage: 'New conversation'
  })
};
const ConversationTitle = ({
  ariaLabelledBy,
  isEditing,
  setIsEditing
}) => {
  const {
    title,
    isLoading
  } = (0, _use_conversation.useConversationTitle)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const hasPersistedConversation = (0, _use_conversation.useHasPersistedConversation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isHovering, setIsHovering] = (0, _react.useState)(false);
  const [previousTitle, setPreviousTitle] = (0, _react.useState)('');
  const [currentText, setCurrentText] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (isLoading || !hasActiveConversation) return;
    const fullText = title || labels.newConversation;

    // Typewriter: ONLY when transitioning from "New conversation" to actual title
    if (previousTitle === labels.newConversation && title) {
      if (currentText.length < fullText.length) {
        const timeout = setTimeout(() => {
          setCurrentText(fullText.substring(0, currentText.length + 1));
        }, 50);
        return () => clearTimeout(timeout);
      }
    } else if (title && title !== previousTitle) {
      // Normal title change: immediate
      setCurrentText(fullText);
    } else if (!title) {
      // Reset when switching to new conversation (no title)
      setCurrentText('');
    }

    // Always track the previous title
    setPreviousTitle(fullText);
  }, [title, currentText, isLoading, previousTitle, hasActiveConversation]);
  const displayedTitle = currentText || previousTitle;
  const handlePencilClick = () => {
    setIsEditing(true);
    setIsHovering(false);
  };
  const handleCancel = () => {
    setIsEditing(false);
  };
  const shouldShowTitle = hasActiveConversation;
  if (!shouldShowTitle) {
    return null;
  }
  if (isEditing) {
    return /*#__PURE__*/_react.default.createElement(_rename_conversation_input.RenameConversationInput, {
      onCancel: handleCancel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 12
      }
    });
  }
  const titleStyles = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
  `;

  // Only show rename icon when there is a conversation ID !== 'new'
  const canRename = hasPersistedConversation;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    onMouseEnter: () => setIsHovering(true),
    onMouseLeave: () => setIsHovering(false),
    "data-test-subj": "agentBuilderConversationTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    id: ariaLabelledBy,
    css: titleStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, displayedTitle)), canRename && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    "aria-label": labels.rename,
    onClick: handlePencilClick,
    color: "text",
    "data-test-subj": "agentBuilderConversationRenameButton",
    css: (0, _react2.css)`
              opacity: ${isHovering ? 1 : 0};
              transition: opacity 0.2s ease;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })));
};
exports.ConversationTitle = ConversationTitle;