"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _onechatCommon = require("@kbn/onechat-common");
var _tool_selection_utils = require("../../../utils/tool_selection_utils");
var _active_tools_status = require("./active_tools_status");
var _tools_search_controls = require("./tools_search_controls");
var _tools_flat_view = require("./tools_flat_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/tools_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolsSelection = ({
  tools,
  toolsLoading,
  selectedTools,
  onToolsChange,
  disabled = false,
  showActiveOnly = false,
  onShowActiveOnlyChange
}) => {
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const displayTools = (0, _react.useMemo)(() => {
    let result = tools;
    if (showActiveOnly) {
      result = tools.filter(tool => {
        return selectedTools.some(selection => {
          return selection.tool_ids.includes(tool.id) || selection.tool_ids.includes('*');
        });
      });
    }
    return result;
  }, [tools, showActiveOnly, selectedTools]);
  const filteredTools = (0, _react.useMemo)(() => {
    if (!searchQuery) {
      return displayTools;
    }
    return _eui.EuiSearchBar.Query.execute(_eui.EuiSearchBar.Query.parse(searchQuery), displayTools, {
      defaultFields: ['id', 'description', 'type']
    });
  }, [searchQuery, displayTools]);
  const activeToolsCount = (0, _react.useMemo)(() => {
    return (0, _onechatCommon.filterToolsBySelection)(tools, selectedTools).length;
  }, [tools, selectedTools]);
  const handleToggleTool = (0, _react.useCallback)(toolId => {
    const newSelection = (0, _tool_selection_utils.toggleToolSelection)(toolId, tools, selectedTools);
    onToolsChange(newSelection);
  }, [selectedTools, onToolsChange, tools]);
  const handleSearchChange = (0, _react.useCallback)(query => {
    setSearchQuery(query);
    setPageIndex(0);
  }, []);
  const handlePageChange = (0, _react.useCallback)(newPageIndex => {
    setPageIndex(newPageIndex);
  }, []);
  const handlePageSizeChange = (0, _react.useCallback)(newPageSize => {
    setPageSize(newPageSize);
    setPageIndex(0);
  }, []);
  if (toolsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_active_tools_status.ActiveToolsStatus, {
    activeToolsCount: activeToolsCount,
    warningThreshold: _onechatCommon.activeToolsCountWarningThreshold,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_tools_search_controls.ToolsSearchControls, {
    displayTools: displayTools,
    searchQuery: searchQuery,
    onSearchChange: handleSearchChange,
    showActiveOnly: showActiveOnly,
    onShowActiveOnlyChange: onShowActiveOnlyChange,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_tools_flat_view.ToolsFlatView, {
    tools: filteredTools,
    selectedTools: selectedTools,
    onToggleTool: handleToggleTool,
    disabled: disabled,
    pageIndex: pageIndex,
    onPageChange: handlePageChange,
    pageSize: pageSize,
    onPageSizeChange: handlePageSizeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }));
};
exports.ToolsSelection = ToolsSelection;