"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isToolResultEvent = exports.isToolProgressEvent = exports.isToolCallEvent = exports.isThinkingCompleteEvent = exports.isRoundCompleteEvent = exports.isReasoningEvent = exports.isMessageCompleteEvent = exports.isMessageChunkEvent = exports.isConversationUpdatedEvent = exports.isConversationIdSetEvent = exports.isConversationCreatedEvent = exports.isBrowserToolCallEvent = exports.ChatEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChatEventType = exports.ChatEventType = /*#__PURE__*/function (ChatEventType) {
  ChatEventType["toolCall"] = "tool_call";
  ChatEventType["browserToolCall"] = "browser_tool_call";
  ChatEventType["toolProgress"] = "tool_progress";
  ChatEventType["toolResult"] = "tool_result";
  ChatEventType["reasoning"] = "reasoning";
  ChatEventType["messageChunk"] = "message_chunk";
  ChatEventType["messageComplete"] = "message_complete";
  ChatEventType["thinkingComplete"] = "thinking_complete";
  ChatEventType["roundComplete"] = "round_complete";
  ChatEventType["conversationCreated"] = "conversation_created";
  ChatEventType["conversationUpdated"] = "conversation_updated";
  ChatEventType["conversationIdSet"] = "conversation_id_set";
  return ChatEventType;
}({}); // Tool call
const isToolCallEvent = event => {
  return event.type === ChatEventType.toolCall;
};
exports.isToolCallEvent = isToolCallEvent;
const isBrowserToolCallEvent = event => {
  return event.type === ChatEventType.browserToolCall;
};

// Tool progress
exports.isBrowserToolCallEvent = isBrowserToolCallEvent;
const isToolProgressEvent = event => {
  return event.type === ChatEventType.toolProgress;
};

// Tool result
exports.isToolProgressEvent = isToolProgressEvent;
const isToolResultEvent = event => {
  return event.type === ChatEventType.toolResult;
};

// reasoning
exports.isToolResultEvent = isToolResultEvent;
const isReasoningEvent = event => {
  return event.type === ChatEventType.reasoning;
};

// Message chunk
exports.isReasoningEvent = isReasoningEvent;
const isMessageChunkEvent = event => {
  return event.type === ChatEventType.messageChunk;
};

// Message complete
exports.isMessageChunkEvent = isMessageChunkEvent;
const isMessageCompleteEvent = event => {
  return event.type === ChatEventType.messageComplete;
};

// Thinking complete
exports.isMessageCompleteEvent = isMessageCompleteEvent;
const isThinkingCompleteEvent = event => {
  return event.type === ChatEventType.thinkingComplete;
};

// Round complete
exports.isThinkingCompleteEvent = isThinkingCompleteEvent;
const isRoundCompleteEvent = event => {
  return event.type === ChatEventType.roundComplete;
};

// conversation created
exports.isRoundCompleteEvent = isRoundCompleteEvent;
const isConversationCreatedEvent = event => {
  return event.type === ChatEventType.conversationCreated;
};

// conversation updated
exports.isConversationCreatedEvent = isConversationCreatedEvent;
const isConversationUpdatedEvent = event => {
  return event.type === ChatEventType.conversationUpdated;
};

// conversation id set
exports.isConversationUpdatedEvent = isConversationUpdatedEvent;
const isConversationIdSetEvent = event => {
  return event.type === ChatEventType.conversationIdSet;
};

/**
 * All types of events that can be emitted from an agent execution.
 */

/**
 * All types of events that can be emitted from the chat API.
 */
exports.isConversationIdSetEvent = isConversationIdSetEvent;