"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntitiesByFuzzySearch = getEntitiesByFuzzySearch;
var _lodash = require("lodash");
var _fuse = _interopRequireDefault(require("fuse.js"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEntitiesByFuzzySearch({
  esClient,
  entity,
  start,
  end,
  index
}) {
  if (Object.keys(entity).length > 1) {
    return [];
  }
  const [field, value] = Object.entries(entity)[0];
  const {
    terms
  } = await esClient.client.termsEnum({
    index: (0, _lodash.castArray)(index).join(','),
    field,
    index_filter: {
      range: {
        '@timestamp': {
          gte: new Date(start).toISOString(),
          lte: new Date(end).toISOString()
        }
      }
    },
    size: 10_000
  });
  const results = new _fuse.default(terms, {
    includeScore: true,
    threshold: 0.75
  }).search(value);
  return (0, _lodash.orderBy)(results, result => result.score, 'asc').slice(0, 5).map(result => result.item);
}