"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aiAssistantRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _services = require("../../services");
var _create_observability_server_route = require("../create_observability_server_route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getObservabilityAlertDetailsContextRoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'GET /internal/observability/assistant/alert_details_contextual_insights',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  params: t.type({
    query: _services.alertDetailsContextRt
  }),
  handler: async ({
    dependencies,
    params,
    context,
    request
  }) => {
    const alertContext = await dependencies.assistant.alertDetailsContextualInsightsService.getAlertDetailsContext({
      core: context.core,
      licensing: context.licensing,
      request
    }, params.query);
    return {
      alertContext
    };
  }
});
const aiAssistantRouteRepository = exports.aiAssistantRouteRepository = {
  ...getObservabilityAlertDetailsContextRoute
};