"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseViewNavigation = void 0;
var _reactRouterDom = require("react-router-dom");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_DEEP_LINK_ID = 'cases';
const generateCaseViewPath = caseId => {
  return (0, _reactRouterDom.generatePath)('/:caseId', {
    caseId
  });
};
const useCaseViewNavigation = () => {
  var _useObservable;
  const {
    application: {
      navigateToApp,
      currentAppId$
    }
  } = (0, _kibana_react.useKibana)().services;
  const currentAppId = (_useObservable = (0, _useObservable2.default)(currentAppId$)) !== null && _useObservable !== void 0 ? _useObservable : '';
  const navigateToCaseView = (0, _react.useCallback)(pathParams => navigateToApp(currentAppId, {
    deepLinkId: CASE_DEEP_LINK_ID,
    path: generateCaseViewPath(pathParams.caseId)
  }), [navigateToApp, currentAppId]);
  return {
    navigateToCaseView
  };
};
exports.useCaseViewNavigation = useCaseViewNavigation;