"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOLinkData = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLOLinkData = rule => {
  return typeof rule.params.sloId === 'string' ? {
    urlParams: {
      sloId: rule.params.sloId
    },
    buttonText: _i18n.i18n.translate('xpack.observability.ruleDetails.viewLinkedSLOButton', {
      defaultMessage: 'View linked SLO'
    }),
    locatorId: _.sloDetailsLocatorID
  } : {
    urlParams: undefined,
    buttonText: '',
    locatorId: ''
  };
};
exports.getSLOLinkData = getSLOLinkData;