"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AutocompleteField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _suggestion_item = require("./suggestion_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/rule_kql_filter/autocomplete_field/autocomplete_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function composeStateUpdaters(...updaters) {
  return (state, props) => updaters.reduce((currentState, updater) => updater(currentState, props) || currentState, state);
}
class AutocompleteField extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      areSuggestionsVisible: false,
      isFocused: false,
      selectedIndex: null
    });
    (0, _defineProperty2.default)(this, "inputElement", null);
    (0, _defineProperty2.default)(this, "handleChangeInputRef", element => {
      this.inputElement = element;
    });
    (0, _defineProperty2.default)(this, "handleChange", evt => {
      this.changeValue(evt.currentTarget.value);
    });
    (0, _defineProperty2.default)(this, "handleKeyDown", evt => {
      const {
        suggestions
      } = this.props;
      switch (evt.key) {
        case 'ArrowUp':
          evt.preventDefault();
          if (suggestions.length > 0) {
            this.setState(composeStateUpdaters(withSuggestionsVisible, withPreviousSuggestionSelected));
          }
          break;
        case 'ArrowDown':
          evt.preventDefault();
          if (suggestions.length > 0) {
            this.setState(composeStateUpdaters(withSuggestionsVisible, withNextSuggestionSelected));
          } else {
            this.updateSuggestions();
          }
          break;
        case 'Enter':
          evt.preventDefault();
          if (this.state.selectedIndex !== null) {
            this.applySelectedSuggestion();
          } else {
            this.submit();
          }
          break;
        case 'Escape':
          evt.preventDefault();
          this.setState(withSuggestionsHidden);
          break;
      }
    });
    (0, _defineProperty2.default)(this, "handleKeyUp", evt => {
      switch (evt.key) {
        case 'ArrowLeft':
        case 'ArrowRight':
        case 'Home':
        case 'End':
          this.updateSuggestions();
          break;
      }
    });
    (0, _defineProperty2.default)(this, "handleFocus", () => {
      this.setState(composeStateUpdaters(withSuggestionsVisible, withFocused));
    });
    (0, _defineProperty2.default)(this, "handleBlur", () => {
      this.setState(composeStateUpdaters(withSuggestionsHidden, withUnfocused));
    });
    (0, _defineProperty2.default)(this, "selectSuggestionAt", index => () => {
      this.setState(withSuggestionAtIndexSelected(index));
    });
    (0, _defineProperty2.default)(this, "applySelectedSuggestion", () => {
      if (this.state.selectedIndex !== null) {
        this.applySuggestionAt(this.state.selectedIndex)();
      }
    });
    (0, _defineProperty2.default)(this, "applySuggestionAt", index => () => {
      const {
        value,
        suggestions
      } = this.props;
      const selectedSuggestion = suggestions[index];
      if (!selectedSuggestion) {
        return;
      }
      const newValue = value.substr(0, selectedSuggestion.start) + selectedSuggestion.text + value.substr(selectedSuggestion.end);
      this.setState(withSuggestionsHidden);
      this.changeValue(newValue);
      this.focusInputElement();
    });
    (0, _defineProperty2.default)(this, "changeValue", value => {
      const {
        onChange
      } = this.props;
      if (onChange) {
        onChange(value);
      }
    });
    (0, _defineProperty2.default)(this, "focusInputElement", () => {
      if (this.inputElement) {
        this.inputElement.focus();
      }
    });
    (0, _defineProperty2.default)(this, "showSuggestions", () => {
      this.setState(withSuggestionsVisible);
    });
    (0, _defineProperty2.default)(this, "submit", () => {
      const {
        isValid,
        onSubmit,
        value
      } = this.props;
      if (isValid && onSubmit) {
        onSubmit(value);
      }
      this.setState(withSuggestionsHidden);
    });
    (0, _defineProperty2.default)(this, "updateSuggestions", () => {
      const inputCursorPosition = this.inputElement ? this.inputElement.selectionStart || 0 : 0;
      this.props.loadSuggestions(this.props.value, inputCursorPosition, 200);
    });
  }
  render() {
    const {
      suggestions,
      isLoadingSuggestions,
      isValid,
      placeholder,
      value,
      disabled,
      'aria-label': ariaLabel,
      compressed,
      theme
    } = this.props;
    const {
      areSuggestionsVisible,
      selectedIndex
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
      onOutsideClick: this.handleBlur,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
            position: relative;
          `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      compressed: compressed,
      fullWidth: true,
      disabled: disabled,
      inputRef: this.handleChangeInputRef,
      isLoading: isLoadingSuggestions,
      isInvalid: !isValid,
      onChange: this.handleChange,
      onFocus: this.handleFocus,
      onKeyDown: this.handleKeyDown,
      onKeyUp: this.handleKeyUp,
      onSearch: this.submit,
      placeholder: placeholder,
      value: value,
      "aria-label": ariaLabel,
      "data-test-subj": "o11ySearchField",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }), areSuggestionsVisible && !isLoadingSuggestions && suggestions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      "data-test-subj": "o11ySuggestionsPanel",
      paddingSize: "none",
      hasShadow: true,
      css: (0, _react2.css)`
                position: absolute;
                width: 100%;
                margin-top: 2px;
                overflow-x: hidden;
                overflow-y: scroll;
                z-index: ${theme === null || theme === void 0 ? void 0 : theme.levels.flyout};
                max-height: 322px;
              `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }, suggestions.map((suggestion, suggestionIndex) => /*#__PURE__*/_react.default.createElement(_suggestion_item.SuggestionItem, {
      key: suggestion.text,
      suggestion: suggestion,
      isSelected: suggestionIndex === selectedIndex,
      onMouseEnter: this.selectSuggestionAt(suggestionIndex),
      onClick: this.applySuggestionAt(suggestionIndex),
      onKeyDown: this.selectSuggestionAt(suggestionIndex),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 17
      }
    }))) : null));
  }
  componentDidMount() {
    if (this.inputElement && this.props.autoFocus) {
      this.inputElement.focus();
    }
  }
  componentDidUpdate(prevProps) {
    const hasNewValue = prevProps.value !== this.props.value;
    const hasNewSuggestions = prevProps.suggestions !== this.props.suggestions;
    if (hasNewValue) {
      this.updateSuggestions();
    }
    if (hasNewValue && this.props.value === '') {
      this.submit();
    }
    if (hasNewSuggestions && this.state.isFocused) {
      this.showSuggestions();
    }
  }
}
exports.AutocompleteField = AutocompleteField;
const withPreviousSuggestionSelected = (state, props) => ({
  ...state,
  selectedIndex: props.suggestions.length === 0 ? null : state.selectedIndex !== null ? (state.selectedIndex + props.suggestions.length - 1) % props.suggestions.length : Math.max(props.suggestions.length - 1, 0)
});
const withNextSuggestionSelected = (state, props) => ({
  ...state,
  selectedIndex: props.suggestions.length === 0 ? null : state.selectedIndex !== null ? (state.selectedIndex + 1) % props.suggestions.length : 0
});
const withSuggestionAtIndexSelected = suggestionIndex => (state, props) => ({
  ...state,
  selectedIndex: props.suggestions.length === 0 ? null : suggestionIndex >= 0 && suggestionIndex < props.suggestions.length ? suggestionIndex : 0
});
const withSuggestionsVisible = state => ({
  ...state,
  areSuggestionsVisible: true
});
const withSuggestionsHidden = state => ({
  ...state,
  areSuggestionsVisible: false,
  selectedIndex: null
});
const withFocused = state => ({
  ...state,
  isFocused: true
});
const withUnfocused = state => ({
  ...state,
  isFocused: false
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AutocompleteField;