"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroups = exports.getGroupQueries = exports.getGroupFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * groupFieldName
 * In some cases, like AAD indices, the field name for group value is different from group.field,
 * in AAD case, it is ALERT_GROUP_VALUE (`kibana.alert.group.value`). groupFieldName allows
 * passing a different field name to be used in the query.
 */
const getGroupQueries = (groups, groupFieldName) => {
  return groups && groups.map(group => ({
    match_phrase: {
      [groupFieldName || group.field]: group.value
    }
  })) || [];
};
exports.getGroupQueries = getGroupQueries;
const getGroupFilters = (groups, groupFieldName) => {
  return getGroupQueries(groups, groupFieldName).map(query => ({
    meta: {},
    query
  }));
};
exports.getGroupFilters = getGroupFilters;
const getGroups = (fields = [], values = []) => {
  return fields.map((_, index) => ({
    field: fields[index],
    value: values[index]
  }));
};
exports.getGroups = getGroups;