"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAnnotationRt = exports.rectFill = exports.getAnnotationByIdRt = exports.findAnnotationRt = exports.deleteAnnotationRt = exports.createAnnotationRt = exports.DEFAULT_ANNOTATION_INDEX = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/Either");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ANNOTATION_INDEX = exports.DEFAULT_ANNOTATION_INDEX = 'observability-annotations';

/**
 * Checks whether a string is a valid ISO timestamp,
 * but doesn't convert it into a Date object when decoding.
 *
 * Copied from x-pack/solutions/observability/plugins/apm/common/runtime_types/date_as_string_rt.ts.
 */
const dateAsStringRt = new t.Type('DateAsString', t.string.is, (input, context) => _Either.either.chain(t.string.validate(input, context), str => {
  const date = new Date(str);
  return isNaN(date.getTime()) ? t.failure(input, context) : t.success(str);
}), t.identity);
const rectFill = exports.rectFill = t.union([t.literal('inside'), t.literal('outside')]);
const createAnnotationRt = exports.createAnnotationRt = t.intersection([t.type({
  annotation: t.partial({
    title: t.string,
    type: t.string,
    style: t.partial({
      icon: t.string,
      color: t.string,
      line: t.partial({
        width: t.number,
        style: t.union([t.literal('dashed'), t.literal('solid'), t.literal('dotted')]),
        iconPosition: t.union([t.literal('top'), t.literal('bottom')]),
        textDecoration: t.union([t.literal('none'), t.literal('name')])
      }),
      rect: t.partial({
        fill: rectFill
      })
    })
  }),
  '@timestamp': dateAsStringRt,
  message: t.string
}), t.partial({
  event: t.intersection([t.type({
    start: dateAsStringRt
  }), t.partial({
    end: dateAsStringRt
  })]),
  tags: t.array(t.string),
  service: t.partial({
    name: t.string,
    environment: t.string,
    version: t.string
  }),
  monitor: t.partial({
    id: t.string
  }),
  slo: t.intersection([t.type({
    id: t.string
  }), t.partial({
    instanceId: t.string
  })]),
  host: t.partial({
    name: t.string
  })
})]);
const deleteAnnotationRt = exports.deleteAnnotationRt = t.type({
  id: t.string
});
const getAnnotationByIdRt = exports.getAnnotationByIdRt = t.type({
  id: t.string
});
const findAnnotationRt = exports.findAnnotationRt = t.partial({
  query: t.string,
  start: t.string,
  end: t.string,
  sloId: t.string,
  sloInstanceId: t.string,
  serviceName: t.string,
  filter: t.string,
  size: t.number
});
const updateAnnotationRt = exports.updateAnnotationRt = t.intersection([t.type({
  id: t.string
}), createAnnotationRt]);