"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasLogs = getHasLogs;
var _server = require("@kbn/observability-plugin/server");
var _es_fields = require("../../../common/es_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasLogs(esClient, agentId) {
  try {
    const result = await esClient.search({
      index: ['logs-*', 'metrics-*'],
      ignore_unavailable: true,
      size: 0,
      terminate_after: 1,
      query: {
        bool: {
          filter: (0, _server.termQuery)(_es_fields.AGENT_ID, agentId)
        }
      }
    });
    const {
      value
    } = result.hits.total;
    return value > 0;
  } catch (error) {
    if (error.statusCode === 404) {
      return false;
    }
    throw error;
  }
}