"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedOtlpServiceTechPreviewVisibility = useManagedOtlpServiceTechPreviewVisibility;
var _public = require("@kbn/kibana-react-plugin/public");
var _feature_flags = require("../../../common/feature_flags");
var _use_managed_otlp_service_availability = require("./use_managed_otlp_service_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns whether the Technical Preview badge should be shown for OTel onboarding flows.
 *
 * The badge should be shown when ALL of the following conditions are met:
 * - Not running on Serverless (mOTLP is already GA in Serverless)
 * - mOTLP service is available (URL is configured and feature flag enabled)
 * - mOTLP is not yet GA (managedOtlpGa feature flag is false)
 */
function useManagedOtlpServiceTechPreviewVisibility() {
  const {
    services: {
      featureFlags,
      context: {
        isServerless
      }
    }
  } = (0, _public.useKibana)();
  const isManagedOtlpServiceAvailable = (0, _use_managed_otlp_service_availability.useManagedOtlpServiceAvailability)();

  // mOTLP is already GA in Serverless, never show the badge
  if (isServerless) {
    return false;
  }

  // Only show the badge when mOTLP service is available (ECH with URL configured)
  if (!isManagedOtlpServiceAvailable) {
    return false;
  }

  // Hide the badge when mOTLP goes GA (feature flag is true)
  const isManagedOtlpGa = featureFlags.getBooleanValue(_feature_flags.IS_MANAGED_OTLP_GA, false);
  return !isManagedOtlpGa;
}