"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantService = void 0;
exports.getResourceName = getResourceName;
exports.resourceNames = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/spaces-plugin/common");
var _lodash = require("lodash");
var _pRetry = _interopRequireDefault(require("p-retry"));
var _chat_function_client = require("./chat_function_client");
var _client = require("./client");
var _knowledge_base_service = require("./knowledge_base_service");
var _create_or_update_conversation_index_assets = require("./index_assets/create_or_update_conversation_index_assets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getResourceName(resource) {
  return `.kibana-observability-ai-assistant-${resource}`;
}
const resourceNames = exports.resourceNames = {
  componentTemplate: {
    conversations: getResourceName('component-template-conversations'),
    kb: getResourceName('component-template-kb')
  },
  writeIndexAlias: {
    conversations: getResourceName('conversations'),
    kb: getResourceName('kb')
  },
  indexPatterns: {
    conversations: getResourceName('conversations*'),
    kb: getResourceName('kb*')
  },
  indexTemplate: {
    conversations: getResourceName('index-template-conversations'),
    kb: getResourceName('index-template-kb')
  },
  concreteWriteIndexName: {
    conversations: getResourceName('conversations-000001'),
    kb: getResourceName('kb-000001')
  }
};
const createConversationIndexAssetsOnce = (0, _lodash.once)((logger, core) => (0, _pRetry.default)(() => (0, _create_or_update_conversation_index_assets.createOrUpdateConversationIndexAssets)({
  logger,
  core
})));
class ObservabilityAIAssistantService {
  constructor({
    logger,
    core,
    config
  }) {
    (0, _defineProperty2.default)(this, "core", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "registrations", []);
    this.core = core;
    this.logger = logger;
    this.config = config;
  }
  async getClient({
    request,
    scopes
  }) {
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    const [[coreStart, plugins]] = await Promise.all([this.core.getStartServices(), createConversationIndexAssetsOnce(this.logger, this.core)]);

    // user will not be found when executed from system connector context
    const user = plugins.security.authc.getCurrentUser(request);
    const soClient = coreStart.savedObjects.getScopedClient(request);
    const uiSettingsClient = coreStart.uiSettings.asScopedToClient(soClient);
    const basePath = coreStart.http.basePath.get(request);
    const {
      spaceId
    } = (0, _common.getSpaceIdFromPath)(basePath, coreStart.http.basePath.serverBasePath);
    const inferenceClient = plugins.inference.getClient({
      request
    });
    const {
      asInternalUser
    } = coreStart.elasticsearch.client;
    const {
      asCurrentUser
    } = coreStart.elasticsearch.client.asScoped(request);
    const analytics = coreStart.analytics;
    const kbService = new _knowledge_base_service.KnowledgeBaseService({
      core: this.core,
      logger: this.logger.get('kb'),
      config: this.config,
      esClient: {
        asInternalUser
      },
      productDoc: plugins.productDocBase.management
    });
    return new _client.ObservabilityAIAssistantClient({
      core: this.core,
      config: this.config,
      actionsClient: await plugins.actions.getActionsClientWithRequest(request),
      uiSettingsClient,
      namespace: spaceId,
      esClient: {
        asInternalUser,
        asCurrentUser
      },
      inferenceClient,
      logger: this.logger,
      user: user ? {
        id: user.profile_uid,
        name: user.username
      } : undefined,
      knowledgeBaseService: kbService,
      scopes: scopes || ['all'],
      analytics
    });
  }
  async getFunctionClient({
    screenContexts,
    signal,
    resources,
    client,
    scopes
  }) {
    const fnClient = new _chat_function_client.ChatFunctionClient(screenContexts);
    const [, pluginsStart] = await this.core.getStartServices();
    const params = {
      signal,
      functions: fnClient,
      resources,
      client,
      scopes,
      pluginsStart
    };
    await Promise.all(this.registrations.map(fn => fn(params).catch(error => {
      this.logger.error(`Error registering functions`);
      this.logger.error(error);
    })));
    return fnClient;
  }
  register(cb) {
    this.registrations.push(cb);
  }
}
exports.ObservabilityAIAssistantService = ObservabilityAIAssistantService;