"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutState = exports.OBSERVABILITY_AI_ASSISTANT_LOCAL_STORAGE_KEY = void 0;
exports.useFlyoutState = useFlyoutState;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var FlyoutPositionMode = /*#__PURE__*/function (FlyoutPositionMode) {
  FlyoutPositionMode["PUSH"] = "push";
  FlyoutPositionMode["OVERLAY"] = "overlay";
  return FlyoutPositionMode;
}(FlyoutPositionMode || {});
const defaultFlyoutState = exports.defaultFlyoutState = {
  flyoutPositionMode: FlyoutPositionMode.OVERLAY,
  isOpen: false
};
const OBSERVABILITY_AI_ASSISTANT_LOCAL_STORAGE_KEY = exports.OBSERVABILITY_AI_ASSISTANT_LOCAL_STORAGE_KEY = 'observabilityAIAssistant_flyoutState';
function useFlyoutState() {
  const [flyoutState = defaultFlyoutState, setFlyoutState, removeFlyoutState] = (0, _useLocalStorage.default)(OBSERVABILITY_AI_ASSISTANT_LOCAL_STORAGE_KEY, defaultFlyoutState);
  return {
    flyoutState,
    setFlyoutState,
    removeFlyoutState
  };
}