"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToHomeIfUnauthorized = RedirectToHomeIfUnauthorized;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectToHomeIfUnauthorized({
  coreStart,
  children
}) {
  var _capabilities$observa, _capabilities$observa2;
  const {
    application: {
      capabilities,
      navigateToApp
    },
    settings
  } = coreStart;
  const chatExperience$ = (0, _react.useMemo)(() => settings.client.get$(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE), [settings.client]);
  const chatExperience = (0, _useObservable.default)(chatExperience$, _aiAssistantCommon.AIChatExperience.Classic);
  const allowed = ((_capabilities$observa = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$observa2 = capabilities.observabilityAIAssistant) === null || _capabilities$observa2 === void 0 ? void 0 : _capabilities$observa2[_public.aiAssistantCapabilities.show]) !== null && _capabilities$observa !== void 0 ? _capabilities$observa : false) && chatExperience !== _aiAssistantCommon.AIChatExperience.Agent;
  (0, _react.useEffect)(() => {
    if (!allowed) {
      navigateToApp('home');
    }
  }, [allowed, navigateToApp]);
  if (!allowed) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
}