"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsIndices = getLogsIndices;
var _server = require("@kbn/core/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogsIndices({
  core,
  logger
}) {
  const [coreStart, pluginsStart] = await core.getStartServices();
  const savedObjectsClient = new _server.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
  try {
    const logsDataAccess = pluginsStart.logsDataAccess;
    const logSourcesService = await logsDataAccess.services.logSourcesServiceFactory.getLogSourcesService(savedObjectsClient);
    const logSources = await logSourcesService.getLogSources();
    return logSources.map(({
      indexPattern
    }) => indexPattern);
  } catch (error) {
    logger.warn(`Failed to resolve logs indices for Observability Agent: ${error.message}`);
    return [];
  }
}