"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnchorLogs = getAnchorLogs;
var _fetch_anchor_log_by_id = require("./fetch_anchor_log_by_id");
var _get_anchor_logs_for_time_range = require("./get_anchor_logs_for_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAnchorLogs({
  esClient,
  logsIndices,
  startTime,
  endTime,
  logsFilter,
  interestingEventFilter,
  correlationFields,
  logger,
  logId,
  maxSequences
}) {
  if (logId) {
    const anchor = await (0, _fetch_anchor_log_by_id.getAnchorLogById)({
      esClient,
      logsIndices,
      logId,
      correlationFields,
      logger
    });
    return anchor ? [anchor] : [];
  }
  return (0, _get_anchor_logs_for_time_range.getAnchorLogsForTimeRange)({
    esClient,
    logsIndices,
    startTime,
    endTime,
    logsFilter,
    interestingEventFilter,
    correlationFields,
    logger,
    maxSequences
  });
}