"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogAiInsights = getLogAiInsights;
var _moment = _interopRequireDefault(require("moment"));
var _inferenceCommon = require("@kbn/inference-common");
var _std = require("@kbn/std");
var _dedent = _interopRequireDefault(require("dedent"));
var _get_log_document_by_id = require("./get_log_document_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogAiInsights({
  index,
  id,
  request,
  esClient,
  dataRegistry,
  inferenceClient,
  connectorId
}) {
  var _logEntry$service, _logEntry$service2;
  const systemPrompt = (0, _dedent.default)(`
    You are assisting an SRE who is viewing a log entry in the Kibana Logs UI.
    Using the provided data produce a concise, action-oriented response.`);
  const logEntry = await (0, _get_log_document_by_id.getLogDocumentById)({
    esClient: esClient.asCurrentUser,
    index,
    id
  });
  if (!logEntry) {
    throw new Error('Log entry not found');
  }
  let context = (0, _dedent.default)(`
    <LogEntryIndex>
    ${index}
    </LogEntryIndex>
    <LogEntryId>
    ${id}
    </LogEntryId>
    <LogEntryFields>
    \`\`\`json
    ${(0, _std.safeJsonStringify)(logEntry)}
    \`\`\`
    </LogEntryFields>
  `);
  if ((_logEntry$service = logEntry.service) !== null && _logEntry$service !== void 0 && _logEntry$service.name && (_logEntry$service2 = logEntry.service) !== null && _logEntry$service2 !== void 0 && _logEntry$service2.environment) {
    var _logEntry$service3, _logEntry$service4;
    const serviceSummary = await dataRegistry.getData('apmServiceSummary', {
      request,
      serviceName: (_logEntry$service3 = logEntry.service) === null || _logEntry$service3 === void 0 ? void 0 : _logEntry$service3.name,
      serviceEnvironment: (_logEntry$service4 = logEntry.service) === null || _logEntry$service4 === void 0 ? void 0 : _logEntry$service4.environment,
      start: (0, _moment.default)(logEntry['@timestamp']).subtract(24, 'hours').toISOString(),
      end: (0, _moment.default)(logEntry['@timestamp']).add(24, 'hours').toISOString()
    });
    context += (0, _dedent.default)(`
      <ServiceSummary>
      \`\`\`json
      ${(0, _std.safeJsonStringify)(serviceSummary)}
      \`\`\`
      </ServiceSummary>
    `);
  }
  const response = await inferenceClient.chatComplete({
    connectorId,
    system: systemPrompt,
    messages: [{
      role: _inferenceCommon.MessageRole.User,
      content: (0, _dedent.default)(`Explain this log message: what it means, where it is from, whether it is expected, and if it is an issue.
          ${context}
          `)
    }]
  });
  return {
    summary: response.content,
    context
  };
}