"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAgentBuilderPlugin = void 0;
var _insights = require("./components/insights");
var _attachment_types = require("./attachment_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAgentBuilderPlugin {
  constructor(initContext) {}
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    const LogAIInsight = (0, _insights.createLogAIInsight)(core, plugins);
    plugins.discoverShared.features.registry.register({
      id: 'observability-logs-ai-insight',
      render: (0, _insights.createLogsAIInsightRenderer)(LogAIInsight)
    });
    (0, _attachment_types.registerAttachmentUiDefinitions)({
      attachments: plugins.onechat.attachments
    });
    return {
      getAlertAIInsight: () => (0, _insights.createAlertAIInsight)(core, plugins),
      getErrorSampleAIInsight: () => (0, _insights.createErrorSampleAIInsight)(core, plugins)
    };
  }
  stop() {}
}
exports.ObservabilityAgentBuilderPlugin = ObservabilityAgentBuilderPlugin;