"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertAiInsight = AlertAiInsight;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _ai_insight = require("../ai_insight");
var _common = require("../../../common");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/insights/alert_ai_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AlertAiInsight({
  alertId,
  alertTitle
}) {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const apiClient = (0, _serverRouteRepositoryClient.createRepositoryClient)({
    http
  });
  const fetchInsight = async () => {
    const response = await apiClient.fetch('POST /internal/observability_agent_builder/ai_insights/alert', {
      signal: null,
      params: {
        body: {
          alertId
        }
      }
    });
    return {
      summary: response.summary,
      context: response.context
    };
  };
  const buildAttachments = (summary, context) => [{
    type: _common.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID,
    data: {
      summary,
      context,
      attachmentLabel: _i18n.i18n.translate('xpack.observabilityAgentBuilder.alertAiInsight.attachmentLabel', {
        defaultMessage: 'Alert summary'
      })
    }
  }, {
    type: _common.OBSERVABILITY_ALERT_ATTACHMENT_TYPE_ID,
    data: {
      alertId,
      ...(alertTitle && {
        attachmentLabel: _i18n.i18n.translate('xpack.observabilityAgentBuilder.alert.attachmentLabel', {
          defaultMessage: '{alertTitle} alert',
          values: {
            alertTitle
          }
        })
      })
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_ai_insight.AiInsight, {
    title: _i18n.i18n.translate('xpack.observabilityAgentBuilder.alertAiInsight.titleLabel', {
      defaultMessage: 'Help me understand this alert'
    }),
    fetchInsight: fetchInsight,
    buildAttachments: buildAttachments,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
}