"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedApiEndpoint = void 0;
exports.getApi = getApi;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _driver = require("./driver");
var _never_fetch_driver = require("./never_fetch_driver");
var _storage = require("./storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let NewsfeedApiEndpoint = exports.NewsfeedApiEndpoint = /*#__PURE__*/function (NewsfeedApiEndpoint) {
  NewsfeedApiEndpoint["KIBANA"] = "kibana";
  NewsfeedApiEndpoint["KIBANA_ANALYTICS"] = "kibana-analytics";
  NewsfeedApiEndpoint["SECURITY_SOLUTION"] = "security-solution";
  NewsfeedApiEndpoint["OBSERVABILITY"] = "observability";
  return NewsfeedApiEndpoint;
}({});
/*
 * Creates an Observable to newsfeed items, powered by the main interval
 * Computes hasNew value from new item hashes saved in localStorage
 */
function getApi(config, kibanaVersion, newsfeedId, isScreenshotMode) {
  const storage = new _storage.NewsfeedStorage(newsfeedId);
  const mainInterval = config.mainInterval.asMilliseconds();
  const createNewsfeedApiDriver = () => {
    if (isScreenshotMode) {
      return new _never_fetch_driver.NeverFetchNewsfeedApiDriver();
    }
    const userLanguage = _i18n.i18n.getLocale();
    const fetchInterval = config.fetchInterval.asMilliseconds();
    return new _driver.NewsfeedApiDriver(kibanaVersion, userLanguage, fetchInterval, storage);
  };
  const driver = createNewsfeedApiDriver();
  const results$ = (0, _rxjs.timer)(0, mainInterval).pipe((0, _rxjs.filter)(() => driver.shouldFetch()), (0, _rxjs.mergeMap)(() => driver.fetchNewsfeedItems(config.service).pipe((0, _rxjs.catchError)(err => {
    window.console.error(err);
    return (0, _rxjs.of)({
      error: err,
      kibanaVersion,
      hasNew: false,
      feedItems: []
    });
  }))), (0, _rxjs.tap)(() => storage.setLastFetchTime(new Date())));
  const merged$ = (0, _rxjs.combineLatest)([results$, storage.isAnyUnread$()]).pipe((0, _rxjs.map)(([results, isAnyUnread]) => {
    return {
      ...results,
      hasNew: results.error ? false : isAnyUnread
    };
  }));
  return {
    fetchResults$: merged$,
    markAsRead: itemHashes => {
      storage.markItemsAsRead(itemHashes);
    }
  };
}