"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuPopoverActionButtons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _top_nav_menu_action_button = require("./top_nav_menu_action_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_popover_action_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopNavMenuPopoverActionButtons = ({
  primaryActionItem,
  secondaryActionItem
}) => {
  const [openPopoverId, setOpenPopoverId] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!primaryActionItem && !secondaryActionItem) {
    return null;
  }
  const handlePopoverToggle = id => {
    setOpenPopoverId(openPopoverId === id ? null : id);
  };
  const handleOnPopoverClose = () => {
    setOpenPopoverId(null);
  };
  const containerCss = (0, _react2.css)`
    margin-top: ${euiTheme.size.m};
    margin-bottom: ${euiTheme.size.m};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    gutterSize: "m",
    alignItems: "center",
    css: containerCss,
    "data-test-subj": "top-nav-menu-popover-action-buttons-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, secondaryActionItem && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_top_nav_menu_action_button.TopNavMenuActionButton, (0, _extends2.default)({}, secondaryActionItem, {
    isPopoverOpen: openPopoverId === secondaryActionItem.id,
    onPopoverToggle: () => {
      handlePopoverToggle(secondaryActionItem.id);
    },
    onPopoverClose: handleOnPopoverClose,
    popoverAnchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }))), primaryActionItem && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_top_nav_menu_action_button.TopNavMenuActionButton, (0, _extends2.default)({}, primaryActionItem, {
    isPopoverOpen: openPopoverId === primaryActionItem.id,
    onPopoverToggle: () => {
      handlePopoverToggle(primaryActionItem.id);
    },
    onPopoverClose: handleOnPopoverClose,
    popoverAnchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }))));
};
exports.TopNavMenuPopoverActionButtons = TopNavMenuPopoverActionButtons;