"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuActionButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _splitButton = require("@kbn/split-button");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("./constants");
var _utils = require("./utils");
var _top_nav_menu_popover = require("./top_nav_menu_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TopNavMenuActionButton = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    run,
    id,
    htmlId,
    label,
    testId,
    iconType,
    disableButton,
    href,
    target,
    isLoading,
    tooltipContent,
    tooltipTitle,
    isPopoverOpen,
    hidden,
    popoverWidth,
    onPopoverToggle,
    onPopoverClose,
    popoverAnchorPosition
  } = props;
  const itemText = (0, _lodash.upperFirst)(label);
  const {
    title,
    content
  } = (0, _utils.getTooltip)({
    tooltipContent,
    tooltipTitle
  });
  const showTooltip = Boolean(content || title);
  const splitButtonProps = 'splitButtonProps' in props ? props.splitButtonProps : undefined;
  const colorProp = 'color' in props ? props.color : undefined;
  const isFilledProp = 'isFilled' in props ? props.isFilled : undefined;
  const minWidthProp = 'minWidth' in props ? props.minWidth : undefined;
  const items = 'items' in props ? props.items : undefined;
  const {
    items: splitButtonItems,
    run: splitButtonRun,
    ...otherSplitButtonProps
  } = splitButtonProps || {};
  const hasItems = items && items.length > 0;
  const hasSplitItems = splitButtonItems && splitButtonItems.length > 0;
  const handleClick = () => {
    if ((0, _utils.isDisabled)(disableButton)) return;
    if (hasItems) {
      onPopoverToggle();
      return;
    }
    run === null || run === void 0 ? void 0 : run();
  };
  const handleSecondaryButtonClick = () => {
    if ((0, _utils.isDisabled)(splitButtonProps === null || splitButtonProps === void 0 ? void 0 : splitButtonProps.isSecondaryButtonDisabled)) return;
    if (hasSplitItems) {
      onPopoverToggle();
      return;
    }
    splitButtonRun === null || splitButtonRun === void 0 ? void 0 : splitButtonRun();
  };
  const commonProps = {
    onClick: href ? undefined : handleClick,
    id: htmlId,
    'data-test-subj': testId || `top-nav-menu-action-button-${id}`,
    iconType,
    isDisabled: (0, _utils.isDisabled)(disableButton),
    href,
    target: href ? target : undefined,
    isLoading,
    size: 's',
    iconSize: 'm'
  };

  // Target the split part of the button for popover behavior.
  const splitButtonCss = (0, _react2.css)`
    & + button {
      background-color: ${isPopoverOpen ? (0, _utils.getIsSelectedColor)({
    color: 'text',
    euiTheme,
    isFilled: false
  }) : undefined};
    }
  `;
  const buttonCss = (0, _react2.css)`
    background-color: ${isPopoverOpen ? (0, _utils.getIsSelectedColor)({
    color: colorProp,
    euiTheme,
    isFilled: Boolean(isFilledProp)
  }) : undefined};
  `;
  const buttonComponent = splitButtonProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: hidden !== null && hidden !== void 0 ? hidden : 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_splitButton.SplitButtonWithNotification, (0, _extends2.default)({}, otherSplitButtonProps, commonProps, {
    secondaryButtonFill: false,
    onSecondaryButtonClick: handleSecondaryButtonClick,
    color: "text",
    "aria-haspopup": hasSplitItems ? 'menu' : undefined,
    isSelected: isPopoverOpen,
    css: splitButtonCss,
    notificationIndicatorPosition: {
      top: _constants.TOP_NAV_MENU_NOTIFICATION_INDICATOR_TOP,
      left: _constants.TOP_NAV_MENU_NOTIFICATION_INDICATOR_LEFT
    },
    notificationIndicatorSize: "m",
    notificationIndicatorColor: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), itemText)) : /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: hidden !== null && hidden !== void 0 ? hidden : 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, commonProps, {
    iconSide: "left",
    "aria-haspopup": hasItems ? 'menu' : undefined,
    isSelected: isPopoverOpen,
    css: buttonCss,
    color: colorProp,
    minWidth: minWidthProp,
    fill: isFilledProp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), itemText));

  /**
   * There is an issue with passing down a button wrapped in a tooltip to popover.
   * Because of that, popover has its own tooltip handling.
   * So we only wrap in tooltip if there are no items (no popover).
   */
  const button = showTooltip && !hasSplitItems && !hasItems ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: content,
    title: title,
    delay: "long",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, buttonComponent) : buttonComponent;
  if (hasItems || hasSplitItems) {
    return /*#__PURE__*/_react.default.createElement(_top_nav_menu_popover.TopNavMenuPopover
    // For split button, only allow popover behavior on the split part of the split button.
    , {
      items: hasSplitItems ? splitButtonItems : items !== null && items !== void 0 ? items : [],
      tooltipContent: content,
      tooltipTitle: title,
      anchorElement: button,
      isOpen: isPopoverOpen,
      popoverWidth: popoverWidth,
      onClose: onPopoverClose,
      anchorPosition: popoverAnchorPosition,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 7
      }
    });
  }
  return button;
};
exports.TopNavMenuActionButton = TopNavMenuActionButton;