"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailDrawer = DetailDrawer;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sparkline = require("../../../sparkline");
var _format_number = require("../../../../lib/format_number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_viewer/views/detail_drawer.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Why is this width here?
const lspvDetailDrawerSparklineContainerStyle = (0, _react2.css)`
  width: 7vw;
`;
function renderIcon(vertex) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: vertex.iconType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 10
    }
  });
}
function renderPluginBasicStats(vertex, timeseriesTooltipXValueFormatter) {
  const eventsLatencyValueFormatter = value => (0, _format_number.formatMetric)(value, '0.[00]a', 'ms/e');
  const latestEventsLatency = Array.isArray(vertex.stats.millis_per_event.data) && vertex.stats.millis_per_event.data.length > 0 ? (0, _lodash.last)(vertex.stats.millis_per_event.data)[1] : null;
  const eventsLatencyRow = vertex.pluginType === 'input' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_latency",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsLatencyLabel",
    defaultMessage: "Events Latency",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: lspvDetailDrawerSparklineContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.millis_per_event.data,
    options: {
      xaxis: vertex.stats.millis_per_event.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsLatencyValueFormatter
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, eventsLatencyValueFormatter(latestEventsLatency)));
  const eventsOutRateValueFormatter = value => (0, _format_number.formatMetric)(value, '0.[0]a', 'e/s');
  const eventsOutRateRow = /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_out_rate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsEmittedRateLabel",
    defaultMessage: "Events Emitted Rate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: lspvDetailDrawerSparklineContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.eventsPerSecond.data,
    options: {
      xaxis: vertex.eventsPerSecond.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsOutRateValueFormatter
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, eventsOutRateValueFormatter(vertex.latestEventsPerSecond)));
  const eventsInValueFormatter = value => (0, _format_number.formatMetric)(value, '0a', 'events');
  const latestEventsIn = Array.isArray(vertex.stats.events_in.data) && vertex.stats.events_in.data.length > 0 ? (0, _lodash.last)(vertex.stats.events_in.data)[1] : null;
  const eventsInRow = vertex.pluginType === 'input' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_in",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsReceivedLabel",
    defaultMessage: "Events Received",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: lspvDetailDrawerSparklineContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.events_in.data,
    options: {
      xaxis: vertex.stats.events_in.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsInValueFormatter
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, eventsInValueFormatter(latestEventsIn)));
  const eventsOutValueFormatter = eventsInValueFormatter;
  const latestEventsOut = Array.isArray(vertex.stats.events_out.data) && vertex.stats.events_out.data.length > 0 ? (0, _lodash.last)(vertex.stats.events_out.data)[1] : null;
  const eventsOutRow = /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_out",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsEmittedLabel",
    defaultMessage: "Events Emitted",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: lspvDetailDrawerSparklineContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.events_out.data,
    options: {
      xaxis: vertex.stats.events_out.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsOutValueFormatter
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, eventsOutValueFormatter(latestEventsOut)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, eventsLatencyRow, eventsOutRateRow, eventsInRow, eventsOutRow));
}
function renderIfBasicStats() {
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.noMetricsForIfDescription",
    defaultMessage: "There are currently no metrics to show for this if condition.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }));
}
function renderQueueBasicStats() {
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.noMetricsForQueueDescription",
    defaultMessage: "There are currently no metrics to show for the queue.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }));
}
function renderBasicStats(vertex, timeseriesTooltipXValueFormatter) {
  switch (vertex.typeString) {
    case 'plugin':
      return renderPluginBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
    case 'if':
      return renderIfBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
    case 'queue':
      return renderQueueBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
  }
}
function renderPluginBasicInfo(vertex) {
  if (vertex.hasExplicitId) {
    return /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.pipeline.detailDrawer.vertexIdDescription",
      defaultMessage: "This {vertexType}'s ID is {vertexId}.",
      values: {
        vertexType: vertex.typeString,
        vertexId: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 62
          }
        }, vertex.id)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.specifyVertexIdDescription",
    defaultMessage: "This {vertexType} does not have an ID explicitly specified. Specifying an ID allows you to track differences across pipeline changes. You can explicitly specify an ID for this plugin like so:",
    values: {
      vertexType: vertex.typeString
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, vertex.name, ' ', `{
  id => "mySpecialId"
}`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }));
}
function renderIfBasicInfo(vertex) {
  const ifCode = `if (${vertex.subtitle}) {
  ...
}`;
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.conditionalStatementDescription",
    defaultMessage: "This is a conditional statement in your pipeline.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, ifCode), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }));
}
function renderQueueBasicInfo() {
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.structureDescription",
    defaultMessage: "This is an internal structure used by Logstash to buffer events between inputs and the rest of the pipeline.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }));
}
function renderBasicInfo(vertex) {
  switch (vertex.typeString) {
    case 'plugin':
      return renderPluginBasicInfo(vertex);
      break;
    case 'if':
      return renderIfBasicInfo(vertex);
      break;
    case 'queue':
      return renderQueueBasicInfo(vertex);
      break;
  }
}
function renderTitle(vertex) {
  switch (vertex.typeString) {
    case 'plugin':
      return `${vertex.title} ${vertex.pluginType}`;
      break;
    case 'if':
    case 'queue':
      return vertex.title;
      break;
  }
}
function DetailDrawer({
  vertex,
  onHide,
  timeseriesTooltipXValueFormatter
}) {
  const detailDrawerTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    onClose: onHide,
    "aria-labelledby": detailDrawerTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, renderIcon(vertex)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: detailDrawerTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 15
    }
  }, renderTitle(vertex)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }, renderBasicInfo(vertex), renderBasicStats(vertex, timeseriesTooltipXValueFormatter))));
}