"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineListing = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _format_number = require("../../../lib/format_number");
var _cluster_status = require("../cluster_status");
var _sparkline = require("../../sparkline");
var _table = require("../../table");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_listing/pipeline_listing.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableCellNumberStyle = theme => (0, _react2.css)`
  font-size: ${(0, _eui.euiFontSize)(theme, 'l').fontSize};
`;
class PipelineListing extends _react.Component {
  tooltipXValueFormatter(xValue, dateFormat) {
    return (0, _moment.default)(xValue).format(dateFormat);
  }
  tooltipYValueFormatter(yValue, format, units) {
    return (0, _format_number.formatMetric)(yValue, format, units);
  }
  getColumns() {
    const {
      onBrush,
      dateFormat
    } = this.props;
    return [{
      name: _i18n.i18n.translate('xpack.monitoring.logstash.pipelines.idTitle', {
        defaultMessage: 'ID'
      }),
      field: 'id',
      sortable: true,
      render: id => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "id",
        href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/logstash/pipelines/${id}`),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      }, id)
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.pipelines.eventsEmittedRateTitle', {
        defaultMessage: 'Events Emitted Rate'
      }),
      field: 'latestThroughput',
      sortable: true,
      render: (value, pipeline) => {
        const throughput = pipeline.metrics.throughput;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
          series: throughput.data,
          onBrush: onBrush,
          tooltip: {
            xValueFormatter: value => this.tooltipXValueFormatter(value, dateFormat),
            yValueFormatter: (0, _lodash.partialRight)(this.tooltipYValueFormatter, throughput.metric.format, throughput.metric.units)
          },
          options: {
            xaxis: throughput.timeRange
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          css: tableCellNumberStyle,
          "data-test-subj": "eventsEmittedRate",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 15
          }
        }, (0, _format_number.formatMetric)(value, '0.[0]a', throughput.metric.units)));
      }
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.logstash.pipelines.numberOfNodesTitle', {
        defaultMessage: 'Number of Nodes'
      }),
      field: 'latestNodesCount',
      sortable: true,
      render: (value, pipeline) => {
        const nodesCount = pipeline.metrics.nodesCount;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 103,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
          series: nodesCount.data,
          onBrush: onBrush,
          tooltip: {
            xValueFormatter: value => this.tooltipXValueFormatter(value, dateFormat),
            yValueFormatter: (0, _lodash.partialRight)(this.tooltipYValueFormatter, nodesCount.metric.format, nodesCount.metric.units)
          },
          options: {
            xaxis: nodesCount.timeRange
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          css: tableCellNumberStyle,
          "data-test-subj": "nodeCount",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 15
          }
        }, (0, _format_number.formatMetric)(value, '0a')));
      }
    }];
  }
  renderStats() {
    if (this.props.statusComponent) {
      const Component = this.props.statusComponent;
      return /*#__PURE__*/_react.default.createElement(Component, {
        stats: this.props.stats,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
      stats: this.props.stats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 12
      }
    });
  }
  render() {
    const {
      data,
      sorting,
      pagination,
      onTableChange,
      upgradeMessage,
      ...props
    } = this.props;
    const sortingOptions = sorting || {
      field: 'id',
      direction: 'asc'
    };
    if (sortingOptions.field === 'name') {
      sortingOptions.field = 'id';
    }
    const columns = this.getColumns();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.pipline_listing.heading",
      defaultMessage: "Logstash pipelines",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }, this.renderStats()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringSSPTable, (0, _extends2.default)({
      "data-test-subj": this.props['data-test-subj'] || 'logstashNodesTable',
      rows: data,
      columns: columns,
      sorting: sortingOptions,
      message: upgradeMessage,
      pagination: pagination,
      search: {
        box: {
          placeholder: _i18n.i18n.translate('xpack.monitoring.logstash.filterPipelinesPlaceholder', {
            defaultMessage: 'Filter Pipelines…'
          })
        }
      },
      onTableChange: onTableChange
    }, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    })))));
  }
}
exports.PipelineListing = PipelineListing;